/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.program;

import com.caucho.config.ConfigContext;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.jca.ResourceAdapterController;
import com.caucho.jca.ResourceArchive;
import com.caucho.jca.ResourceArchiveManager;
import com.caucho.util.L10N;
import com.caucho.webbeans.Names;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.webbeans.ComponentFactory;

public class ResourceAdapterAssociationProgram
extends ConfigProgram {
    private static final L10N L = new L10N(ResourceAdapterAssociationProgram.class);
    private final ResourceAdapterController _raController;

    public ResourceAdapterAssociationProgram(Class cl) {
        ResourceArchive ra = ResourceArchiveManager.findResourceArchive(cl.getName());
        if (ra == null) {
            throw new ConfigException(L.l("'{0}' does not have a defined resource-adapter.  Check the rar or META-INF/resin-ra.xml files", (Object)cl.getName()));
        }
        WebBeansContainer webBeans = WebBeansContainer.create();
        ComponentFactory<ResourceAdapterController> comp = webBeans.resolveByType(ResourceAdapterController.class, new Annotation[]{Names.create(ra.getResourceAdapterClass().getName())});
        if (comp == null) {
            throw new ConfigException(L.l("'{0}' does not have a configured resource-adapter for '{1}'.", (Object)ra.getResourceAdapterClass().getName(), (Object)cl.getName()));
        }
        this._raController = (ResourceAdapterController)comp.get();
    }

    public void inject(Object bean, ConfigContext env) {
        try {
            ResourceAdapterAssociation association = (ResourceAdapterAssociation)bean;
            association.setResourceAdapter(this._raController.getResourceAdapter());
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }
}

