/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.jdbc.GenericMetaData;
import com.caucho.util.Log;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class OracleMetaData
extends GenericMetaData {
    private static final Logger log = Log.open(OracleMetaData.class);

    protected OracleMetaData(DataSource ds) {
        super(ds);
    }

    public String getFalseLiteral() {
        return "0";
    }

    public boolean isTruncateBlobBeforeDelete() {
        return true;
    }

    public String getCreateColumnSQL(int sqlType, int length, int precision, int scale) {
        switch (sqlType) {
            case 91: 
            case 92: {
                return "DATE";
            }
            case 8: {
                return "DOUBLE PRECISION";
            }
        }
        return super.getCreateColumnSQL(sqlType, length, precision, scale);
    }

    public boolean supportsPositionFunction() {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsUpdateTableAlias() {
        return true;
    }

    public String createSequenceSQL(String name, int size) {
        if (size > 1) {
            return "CREATE SEQUENCE " + name + " INCREMENT BY " + size;
        }
        return "CREATE SEQUENCE " + name;
    }

    public String selectSequenceSQL(String name) {
        return "SELECT " + name + ".nextval FROM DUAL";
    }
}

