/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.jdbc.GenericMetaData;
import com.caucho.util.Log;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class PostgresMetaData
extends GenericMetaData {
    private static final Logger log = Log.open(PostgresMetaData.class);

    protected PostgresMetaData(DataSource ds) {
        super(ds);
    }

    public String getFalseLiteral() {
        return "false";
    }

    public boolean supportsPositionFunction() {
        return true;
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsUpdateTableAlias() {
        return false;
    }

    public String createSequenceSQL(String name, int size) {
        if (size > 1) {
            return "CREATE SEQUENCE " + name + " INCREMENT " + size;
        }
        return "CREATE SEQUENCE " + name;
    }

    public String selectSequenceSQL(String name) {
        return "SELECT Nextval('" + name + "')";
    }

    public String testSequenceSQL(String name) {
        return "SELECT Currval('" + name + "')";
    }

    public String generateBoolean(String term) {
        return "(" + term + " = 't')";
    }
}

