/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.queue.AbstractDestination;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.MessageAvailableListener;
import com.caucho.jms.selector.Selector;
import com.caucho.jms.selector.SelectorParser;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class MessageConsumerImpl
implements MessageConsumer,
MessageAvailableListener {
    static final Logger log = Logger.getLogger(MessageConsumerImpl.class.getName());
    static final L10N L = new L10N(MessageConsumerImpl.class);
    private final Object _consumerLock = new Object();
    protected final JmsSession _session;
    private AbstractQueue _queue;
    private MessageListener _messageListener;
    private ClassLoader _listenerClassLoader;
    private String _messageSelector;
    protected Selector _selector;
    private boolean _noLocal;
    private boolean _isAutoAcknowledge;
    private volatile boolean _isClosed;

    MessageConsumerImpl(JmsSession session, AbstractQueue queue, String messageSelector, boolean noLocal) throws JMSException {
        this._session = session;
        this._queue = queue;
        this._messageSelector = messageSelector;
        if (this._messageSelector != null) {
            SelectorParser parser = new SelectorParser();
            this._selector = parser.parse(messageSelector);
        }
        this._noLocal = noLocal;
        this._queue.addMessageAvailableListener(this);
        switch (this._session.getAcknowledgeMode()) {
            case 1: 
            case 3: {
                this._isAutoAcknowledge = true;
                break;
            }
            default: {
                this._isAutoAcknowledge = false;
            }
        }
    }

    protected AbstractDestination getDestination() throws JMSException {
        if (this._isClosed || this._session.isClosed()) {
            throw new IllegalStateException(L.l("getDestination(): MessageConsumer is closed."));
        }
        return this._queue;
    }

    public boolean getNoLocal() throws JMSException {
        if (this._isClosed || this._session.isClosed()) {
            throw new IllegalStateException(L.l("getNoLocal(): MessageConsumer is closed."));
        }
        return this._noLocal;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this._isClosed || this._session.isClosed()) {
            throw new IllegalStateException(L.l("getNoLocal(): MessageConsumer is closed."));
        }
        return this._messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.setMessageListener(listener, -1L);
    }

    public void setMessageListener(MessageListener listener, long pollInterval) throws JMSException {
        if (this._isClosed || this._session.isClosed()) {
            throw new IllegalStateException(L.l("setMessageListener(): MessageConsumer is closed."));
        }
        this._messageListener = listener;
        this._listenerClassLoader = Thread.currentThread().getContextClassLoader();
        this._session.setAsynchronous();
    }

    public String getMessageSelector() throws JMSException {
        if (this._isClosed || this._session.isClosed()) {
            throw new IllegalStateException(L.l("getMessageSelector(): MessageConsumer is closed."));
        }
        return this._messageSelector;
    }

    public Selector getSelector() {
        return this._selector;
    }

    public boolean isActive() throws JMSException {
        if (this._isClosed || this._session.isClosed()) {
            throw new IllegalStateException(L.l("isActive(): MessageConsumer is closed."));
        }
        return this._session.isActive() && !this._isClosed;
    }

    public boolean isClosed() {
        return this._isClosed || this._session.isClosed();
    }

    public Message receive() throws JMSException {
        return this.receiveImpl(0x3FFFFFFFFFFFFFFFL);
    }

    public Message receiveNoWait() throws JMSException {
        return this.receiveImpl(0L);
    }

    public Message receive(long timeout) throws JMSException {
        Message msg = this.receiveImpl(timeout);
        if (msg != null && log.isLoggable(Level.FINE)) {
            log.fine(this._queue + " receive message " + msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveImpl(long timeout) throws JMSException {
        long expireTime;
        if (this._isClosed || this._session.isClosed()) {
            throw new IllegalStateException(L.l("receiveNoWait(): MessageConsumer is closed."));
        }
        if (0x3FFFFFFFFFFFFFFFL < timeout || timeout < 0L) {
            timeout = 0x3FFFFFFFFFFFFFFFL;
        }
        long now = Alarm.getCurrentTime();
        long l = expireTime = timeout > 0L ? now + timeout : 0L;
        while (this._session.isActive()) {
            MessageImpl msg = this._queue.receive(this._isAutoAcknowledge);
            if (msg == null) {
                Object object = this._consumerLock;
                synchronized (object) {
                    if (expireTime <= Alarm.getCurrentTime() || Alarm.isTest()) {
                        return null;
                    }
                    try {
                        this._consumerLock.wait(expireTime - Alarm.getCurrentTime());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (this._selector != null && !this._selector.isMatch(msg)) {
                msg.acknowledge();
                continue;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._queue + " receiving message " + msg);
            }
            if (!this._isAutoAcknowledge) {
                this._session.addTransactedReceive(this._queue, msg);
            }
            return msg;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyMessageAvailable() {
        Object object = this._consumerLock;
        synchronized (object) {
            this._consumerLock.notifyAll();
        }
        return this._session.notifyMessageAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleMessage(MessageListener listener) {
        block10: {
            if (this._messageListener != null) {
                listener = this._messageListener;
            }
            if (listener == null) {
                return false;
            }
            MessageImpl msg = null;
            try {
                msg = this._queue.receive(false);
                if (msg == null) break block10;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this._queue + " deliver " + msg + " to listener " + listener);
                }
                msg.setSession(this._session);
                if (this._selector == null || this._selector.isMatch(msg)) {
                    this._session.addTransactedReceive(this._queue, msg);
                    Thread thread = Thread.currentThread();
                    ClassLoader oldLoader = thread.getContextClassLoader();
                    try {
                        thread.setContextClassLoader(this._listenerClassLoader);
                        listener.onMessage((Message)msg);
                        Object var6_6 = null;
                        thread.setContextClassLoader(oldLoader);
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        thread.setContextClassLoader(oldLoader);
                        throw throwable;
                    }
                }
                if (this._session.getTransacted()) {
                    this._session.commit();
                } else {
                    msg.acknowledge();
                }
                return true;
            }
            catch (Exception e) {
                log.log(Level.WARNING, L.l("{0}: message listener '{1}' failed for message '{2}' with exception\n{3}", (Object)this, (Object)listener, (Object)msg, (Object)e.toString()), e);
                this._queue.addListenerException(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        Object object = this._consumerLock;
        synchronized (object) {
            this._consumerLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        MessageConsumerImpl messageConsumerImpl = this;
        synchronized (messageConsumerImpl) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        this._queue.removeMessageAvailableListener(this);
        this._session.removeConsumer(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._queue + "]";
    }
}

