/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.queue.AbstractDestination;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;

public class MessageProducerImpl
implements MessageProducer {
    static final L10N L = new L10N(MessageProducer.class);
    private int _deliveryMode = 2;
    private boolean _disableMessageId = true;
    private boolean _disableMessageTimestamp = true;
    private int _priority = 4;
    private long _timeToLive = 2592000000L;
    protected JmsSession _session;
    protected AbstractDestination _queue;

    public MessageProducerImpl(JmsSession session, AbstractDestination queue) {
        this._session = session;
        this._queue = queue;
    }

    public Destination getDestination() throws JMSException {
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("getDestination(): message producer is closed."));
        }
        return this._queue;
    }

    public int getDeliveryMode() throws JMSException {
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("getDeliveryMode(): message producer is closed."));
        }
        return this._deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("setDeliveryMode(): message producer is closed."));
        }
        this._deliveryMode = deliveryMode;
    }

    public boolean getDisableMessageID() throws JMSException {
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("getDisableMessageID(): message producer is closed."));
        }
        return this._disableMessageId;
    }

    public void setDisableMessageID(boolean disable) throws JMSException {
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("setDisableMessageID(): message producer is closed."));
        }
        this._disableMessageId = disable;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("getDisableMessageTimestam(): message producer is closed."));
        }
        return this._disableMessageTimestamp;
    }

    public void setDisableMessageTimestamp(boolean disable) throws JMSException {
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("setDeliveryMode(): message producer is closed."));
        }
        this._disableMessageTimestamp = disable;
    }

    public int getPriority() throws JMSException {
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("getPriority(): message producer is closed."));
        }
        return this._priority;
    }

    public void setPriority(int priority) throws JMSException {
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("setDeliveryMode(): message producer is closed."));
        }
        this._priority = priority;
    }

    public long getTimeToLive() throws JMSException {
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("getTimeToLive(): message producer is closed."));
        }
        return this._timeToLive;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("setTimeToLive(): message producer is closed."));
        }
        this._timeToLive = timeToLive;
    }

    public void send(Message message) throws JMSException {
        if (message == null) {
            throw new NullPointerException(L.l("jms message cannot be null for send()"));
        }
        this.send(this._queue, message, this._deliveryMode, this._priority, this._timeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (message == null) {
            throw new NullPointerException(L.l("jms message cannot be null for send()"));
        }
        this.send(this._queue, message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (message == null) {
            throw new NullPointerException(L.l("jms message cannot be null for send()"));
        }
        if (destination == null) {
            throw new NullPointerException(L.l("jms destination cannot be null for send()"));
        }
        this.send(destination, message, this._deliveryMode, this._priority, this._timeToLive);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (destination == null) {
            destination = this._queue;
        } else if (this._queue != null && destination != this._queue) {
            throw new UnsupportedOperationException(L.l("MessageProducer: '{0}' does not match the queue '{1}'", (Object)destination, (Object)this._queue));
        }
        if (destination == null) {
            throw new UnsupportedOperationException(L.l("MessageProducer: null destination is not supported."));
        }
        if (this._session == null || this._session.isClosed()) {
            throw new IllegalStateException(L.l("getDeliveryMode(): message producer is closed."));
        }
        this._session.send((AbstractDestination)destination, message, deliveryMode, priority, timeToLive);
    }

    protected long calculateExpiration(long timeToLive) {
        if (timeToLive <= 0L) {
            return timeToLive;
        }
        return timeToLive + Alarm.getCurrentTime();
    }

    public void close() throws JMSException {
        this._session = null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this._queue + "]";
    }
}

