/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.jms.connection.ConnectionImpl;
import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.connection.QueueReceiverImpl;
import com.caucho.jms.connection.QueueSenderImpl;
import com.caucho.jms.connection.TemporaryQueueImpl;
import com.caucho.jms.queue.AbstractQueue;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.XAQueueSession;

public class QueueSessionImpl
extends JmsSession
implements XAQueueSession,
QueueSession {
    public QueueSessionImpl(ConnectionImpl connection, boolean isTransacted, int ackMode, boolean isXA) throws JMSException {
        super(connection, isTransacted, ackMode, isXA);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkOpen();
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        TemporaryQueueImpl temp;
        this.checkOpen();
        if (queue == null) {
            throw new InvalidDestinationException(L.l("queue is null.  Destination may not be null for Session.createReceiver"));
        }
        if (!(queue instanceof AbstractQueue)) {
            throw new InvalidDestinationException(L.l("'{0}' is an unknown destination.  The destination must be a Resin JMS Destination.", (Object)queue));
        }
        AbstractQueue dest = (AbstractQueue)queue;
        if (dest instanceof TemporaryQueueImpl && (temp = (TemporaryQueueImpl)dest).getSession() != this) {
            throw new IllegalStateException(L.l("temporary queue '{0}' does not belong to this session '{1}'", (Object)queue, (Object)this));
        }
        QueueReceiverImpl receiver = new QueueReceiverImpl(this, dest, messageSelector);
        this.addConsumer(receiver);
        return receiver;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        TemporaryQueueImpl temp;
        this.checkOpen();
        if (queue == null) {
            return new QueueSenderImpl((JmsSession)this, null);
        }
        if (!(queue instanceof AbstractQueue)) {
            throw new InvalidDestinationException(L.l("'{0}' is an unknown destination.  The destination must be a Resin JMS destination for Session.createProducer.", (Object)queue));
        }
        AbstractQueue dest = (AbstractQueue)queue;
        if (dest instanceof TemporaryQueueImpl && (temp = (TemporaryQueueImpl)dest).getSession() != this) {
            throw new IllegalStateException(L.l("temporary queue '{0}' does not belong to this session '{1}'", (Object)queue, (Object)this));
        }
        return new QueueSenderImpl((JmsSession)this, dest);
    }

    public Topic createTopic(String topicName) throws JMSException {
        throw new IllegalStateException(L.l("QueueSession: createTopic() is invalid."));
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new IllegalStateException(L.l("QueueSession: createTemporaryTopic() is invalid."));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        throw new IllegalStateException(L.l("QueueSession: createDurableSubscriber() is invalid."));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new IllegalStateException(L.l("QueueSession: createDurableSubscriber() is invalid."));
    }

    public void unsubscribe(String name) throws JMSException {
        throw new IllegalStateException(L.l("QueueSession: unsubscribe() is invalid."));
    }

    public QueueSession getQueueSession() {
        return this;
    }
}

