/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.memory.MemoryTopic;
import com.caucho.jms.queue.MessageAvailableListener;
import com.caucho.util.L10N;
import java.util.ArrayList;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;

public class TemporaryTopicImpl
extends MemoryTopic
implements TemporaryTopic {
    private static final L10N L = new L10N(TemporaryTopicImpl.class);
    private static int _idCount;
    private JmsSession _session;
    private ArrayList<MessageAvailableListener> _consumerList = new ArrayList();

    TemporaryTopicImpl(JmsSession session) {
        this._session = session;
        this.setName("TemporaryTopic-" + _idCount++);
    }

    JmsSession getSession() {
        return this._session;
    }

    public void addMessageAvailableListener(MessageAvailableListener consumer) {
        if (!this._consumerList.contains(consumer)) {
            this._consumerList.add(consumer);
        }
    }

    public void removeMessageAvailableListener(MessageAvailableListener consumer) {
        this._consumerList.remove(consumer);
    }

    public void delete() throws JMSException {
        if (this._consumerList.size() > 0) {
            throw new IllegalStateException(L.l("temporary topic is still active"));
        }
    }
}

