/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.connection.MessageConsumerImpl;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.AbstractTopic;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class TopicSubscriberImpl
extends MessageConsumerImpl
implements TopicSubscriber {
    private static final Logger log = Logger.getLogger(TopicSubscriberImpl.class.getName());
    private static final L10N L = new L10N(TopicSubscriberImpl.class);
    private AbstractTopic _topic;
    private AbstractQueue _subscription;

    TopicSubscriberImpl(JmsSession session, AbstractTopic topic, String messageSelector, boolean noLocal) throws JMSException {
        super(session, topic.createSubscriber(session, messageSelector, noLocal), messageSelector, noLocal);
        this._topic = topic;
        this._subscription = (AbstractQueue)this.getDestination();
    }

    TopicSubscriberImpl(JmsSession session, AbstractTopic topic, AbstractQueue subscription, String messageSelector, boolean noLocal) throws JMSException {
        super(session, subscription, messageSelector, noLocal);
        this._topic = topic;
        this._subscription = subscription;
    }

    public Topic getTopic() throws JMSException {
        return this._topic;
    }

    public void close() {
        AbstractQueue subscription = this._subscription;
        this._subscription = null;
        if (subscription != null) {
            this._topic.closeSubscriber(subscription);
            subscription.close();
        }
    }
}

