/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.file;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.file.FileQueueEntry;
import com.caucho.jms.file.FileQueueStore;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.MessageType;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Topic;

public class FileQueue
extends AbstractQueue
implements Topic {
    private static final L10N L = new L10N(FileQueue.class);
    private static final Logger log = Logger.getLogger(FileQueue.class.getName());
    private final FileQueueStore _store;
    private final Object _queueLock = new Object();
    private boolean _isStartComplete;
    private FileQueueEntry[] _head = new FileQueueEntry[10];
    private FileQueueEntry[] _tail = new FileQueueEntry[10];

    public FileQueue() {
        this._store = new FileQueueStore(this._messageFactory);
    }

    public FileQueue(String name) {
        this();
        this.setName(name);
        this.init();
    }

    public void setPath(Path path) {
        this._store.setPath(path);
    }

    public Path getPath() {
        return this._store.getPath();
    }

    public void setTablePrefix(String prefix) {
        this._store.setTablePrefix(prefix);
    }

    public String getUrl() {
        return "file:name=" + this.getName() + ";path=" + this._store.getPath().getURL();
    }

    public int getQueueSize() {
        int count = 0;
        for (int i = 0; i < this._head.length; ++i) {
            FileQueueEntry entry = this._head[i];
            while (entry != null) {
                ++count;
                entry = entry._next;
            }
        }
        return count;
    }

    public void init() {
        this._store.setName(this.getName());
        this._store.init();
        this._isStartComplete = this._store.receiveStart(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JmsSession session, MessageImpl msg, long expires) {
        int priority = 1;
        long id = this._store.send(msg, priority, expires);
        Object object = this._queueLock;
        synchronized (object) {
            FileQueueEntry entry = this.addEntry(id, msg.getJMSMessageID(), -1L, priority, expires, null);
            entry.setMessage(msg);
        }
        this.notifyMessageAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBackup(JmsSession session, MessageImpl msg, long leaseTimeout, int priority, long expires) {
        Object object = this._queueLock;
        synchronized (object) {
            long id = this._store.send(msg, priority, expires);
            FileQueueEntry entry = this.addEntry(id, msg.getJMSMessageID(), leaseTimeout, priority, expires, null);
            entry.setMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageImpl receive(boolean isAutoAck) {
        Object object = this._queueLock;
        synchronized (object) {
            for (int i = this._head.length - 1; i >= 0; --i) {
                FileQueueEntry entry = this._head[i];
                while (entry != null) {
                    if (entry.isLease() && !entry.isRead()) {
                        entry.setRead(true);
                        MessageImpl msg = entry.getMessage();
                        if (msg == null) {
                            msg = this._store.readMessage(entry.getId(), entry.getType());
                            entry.setMessage(msg);
                        }
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(this + " receive " + msg + " auto-ack=" + isAutoAck);
                        }
                        if (isAutoAck || msg == null) {
                            this.removeEntry(entry);
                            this._store.delete(entry.getId());
                        }
                        if (msg != null) {
                            return msg;
                        }
                    }
                    entry = entry._next;
                }
            }
        }
        if (!this._isStartComplete) {
            object = this;
            synchronized (object) {
                if (!this._isStartComplete) {
                    this._isStartComplete = this._store.receiveStart(this);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(String msgId) {
        Object object = this._queueLock;
        synchronized (object) {
            for (int i = this._head.length - 1; i >= 0; --i) {
                FileQueueEntry entry = this._head[i];
                while (entry != null) {
                    if (msgId.equals(entry.getMsgId())) {
                        if (entry.isRead()) {
                            entry.setRead(false);
                            MessageImpl msg = entry.getMessage();
                            if (msg != null) {
                                msg.setJMSRedelivered(true);
                            }
                        }
                        return;
                    }
                    entry = entry._next;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(String msgId) {
        Object object = this._queueLock;
        synchronized (object) {
            for (int i = this._head.length - 1; i >= 0; --i) {
                FileQueueEntry entry = this._head[i];
                while (entry != null) {
                    if (msgId.equals(entry.getMsgId())) {
                        if (entry.isRead()) {
                            this.removeEntry(entry);
                            this._store.delete(entry.getId());
                        }
                        return;
                    }
                    entry = entry._next;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileQueueEntry addEntry(long id, String msgId, long leaseTimeout, int priority, long expire, MessageType type) {
        if (priority < 0) {
            priority = 0;
        } else if (this._head.length <= priority) {
            priority = this._head.length;
        }
        FileQueueEntry entry = new FileQueueEntry(id, msgId, leaseTimeout, priority, expire, type);
        Object object = this._queueLock;
        synchronized (object) {
            entry._prev = this._tail[priority];
            if (this._tail[priority] != null) {
                this._tail[priority]._next = entry;
            } else {
                this._head[priority] = entry;
            }
            this._tail[priority] = entry;
            return entry;
        }
    }

    public void removeMessage(String msgId) {
        if (this.removeMessageEntry(msgId)) {
            this._store.remove(msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMessageEntry(String msgId) {
        Object object = this._queueLock;
        synchronized (object) {
            for (int i = this._head.length - 1; i >= 0; --i) {
                FileQueueEntry entry = this._head[i];
                while (entry != null) {
                    if (msgId.equals(entry.getMsgId())) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(this + " remove " + msgId);
                        }
                        this.removeEntry(entry);
                        return true;
                    }
                    entry = entry._next;
                }
            }
        }
        return false;
    }

    private void removeEntry(FileQueueEntry entry) {
        int priority = entry.getPriority();
        FileQueueEntry prev = entry._prev;
        FileQueueEntry next = entry._next;
        if (prev != null) {
            prev._next = next;
        } else {
            this._head[priority] = next;
        }
        if (next != null) {
            next._prev = prev;
        } else {
            this._tail[priority] = prev;
        }
    }
}

