/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.file;

import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.MessageType;
import com.caucho.util.Alarm;
import java.lang.ref.SoftReference;

public class FileQueueEntry {
    private final long _id;
    private final int _priority;
    private final long _leaseExpire;
    private final String _msgId;
    FileQueueEntry _prev;
    FileQueueEntry _next;
    FileQueueEntry _nextPriority;
    private long _expiresTime;
    private MessageType _type;
    private SoftReference<MessageImpl> _msg;
    private boolean _isRead;

    public FileQueueEntry(long id, String msgId, long leaseTimeout, int priority, long expiresTime) {
        if (msgId == null) {
            throw new NullPointerException();
        }
        this._id = id;
        this._msgId = msgId;
        this._leaseExpire = leaseTimeout + Alarm.getCurrentTime();
        this._expiresTime = expiresTime;
        this._priority = priority;
    }

    public FileQueueEntry(long id, String msgId, long leaseTimeout, int priority, long expiresTime, MessageType type) {
        if (msgId == null) {
            throw new NullPointerException();
        }
        this._id = id;
        this._msgId = msgId;
        this._leaseExpire = leaseTimeout + Alarm.getCurrentTime();
        this._priority = priority;
        this._expiresTime = expiresTime;
        this._type = type;
    }

    public FileQueueEntry(long id, String msgId, long leaseTimeout, int priority, long expiresTime, MessageImpl msg) {
        if (msgId == null) {
            throw new NullPointerException();
        }
        this._id = id;
        this._msgId = msgId;
        this._leaseExpire = leaseTimeout + Alarm.getCurrentTime();
        this._priority = priority;
        this._expiresTime = expiresTime;
        this._msg = new SoftReference<MessageImpl>(msg);
    }

    public long getId() {
        return this._id;
    }

    public String getMsgId() {
        return this._msgId;
    }

    public MessageType getType() {
        return this._type;
    }

    public void setType(MessageType type) {
        this._type = type;
    }

    public MessageImpl getMessage() {
        SoftReference<MessageImpl> ref = this._msg;
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public void setMessage(MessageImpl msg) {
        this._msg = new SoftReference<MessageImpl>(msg);
    }

    public boolean isLease() {
        return this._leaseExpire < Alarm.getCurrentTime();
    }

    public boolean isRead() {
        return this._isRead;
    }

    public void setRead(boolean isRead) {
        this._isRead = isRead;
    }

    public int getPriority() {
        return this._priority;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "," + this._msgId + ",pri=" + this._priority + "]";
    }
}

