/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.file;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.file.FileQueueStore;
import com.caucho.jms.file.FileSubscriberQueue;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.AbstractTopic;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.jms.JMSException;

public class FileTopic
extends AbstractTopic {
    private static final Logger log = Logger.getLogger(FileTopic.class.getName());
    private final FileQueueStore _store;
    private HashMap<String, AbstractQueue> _durableSubscriptionMap = new HashMap();
    private ArrayList<AbstractQueue> _subscriptionList = new ArrayList();
    private int _id;

    public FileTopic() {
        this._store = new FileQueueStore(this._messageFactory);
    }

    public void setPath(Path path) {
        this._store.setPath(path);
    }

    public String getUrl() {
        return "file:name=" + this.getName() + ";path=" + this._store.getPath().getURL();
    }

    public void init() {
    }

    public AbstractQueue createSubscriber(JmsSession session, String name, boolean noLocal) {
        if (name != null) {
            AbstractQueue queue = this._durableSubscriptionMap.get(name);
            if (queue == null) {
                queue = new FileSubscriberQueue(this, session, noLocal);
                queue.setName(this.getName() + ":sub-" + name);
                this._subscriptionList.add(queue);
                this._durableSubscriptionMap.put(name, queue);
            }
            return queue;
        }
        FileSubscriberQueue queue = new FileSubscriberQueue(this, session, noLocal);
        queue.setName(this.getName() + ":sub-" + this._id++);
        this._subscriptionList.add(queue);
        return queue;
    }

    public void closeSubscriber(AbstractQueue queue) {
        if (!this._durableSubscriptionMap.values().contains(queue)) {
            this._subscriptionList.remove(queue);
        }
    }

    public void send(JmsSession session, MessageImpl msg, long timeout) throws JMSException {
        for (int i = 0; i < this._subscriptionList.size(); ++i) {
            this._subscriptionList.get(i).send(session, msg, timeout);
        }
    }

    public String toString() {
        return "FileTopic[" + this.getTopicName() + "]";
    }
}

