/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.jms.JMSExceptionWrapper;
import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.jdbc.JdbcManager;
import com.caucho.jms.jdbc.JdbcMessage;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.queue.PollingQueue;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.sql.DataSource;

public class JdbcQueue
extends PollingQueue {
    static final Logger log = Logger.getLogger(JdbcQueue.class.getName());
    static final L10N L = new L10N(JdbcQueue.class);
    protected JdbcManager _jdbcManager = new JdbcManager();
    private String _name;
    private int _id;
    private int _consumerId;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getQueueName() {
        return this.getName();
    }

    public void setQueueName(String name) {
        this.setName(name);
    }

    public int getId() {
        return this._id;
    }

    public void setJdbcManager(JdbcManager jdbcManager) {
        this._jdbcManager = jdbcManager;
    }

    public JdbcManager getJdbcManager() {
        return this._jdbcManager;
    }

    public void setDataSource(DataSource dataSource) {
        this._jdbcManager.setDataSource(dataSource);
    }

    public void setTablespace(String tablespace) {
        this._jdbcManager.setTablespace(tablespace);
    }

    public void init() throws ConfigException {
        try {
            if (this._jdbcManager.getDataSource() == null) {
                throw new ConfigException(L.l("JdbcQueue requires a <data-source> element."));
            }
            if (this.getName() == null) {
                throw new ConfigException(L.l("JdbcQueue requires a <queue-name> element."));
            }
            this._jdbcManager.init();
            this._id = this.createDestination(this.getName(), false);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void send(JmsSession session, MessageImpl message, long expireTime) throws JMSException {
        try {
            JdbcMessage jdbcMessage = this._jdbcManager.getJdbcMessage();
            jdbcMessage.send(message, this._id, expireTime);
        }
        catch (Exception e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageImpl receive(boolean isAutoAck) throws JMSException {
        try {
            MessageImpl messageImpl;
            Connection conn;
            block12: {
                MessageImpl messageImpl2;
                block11: {
                    long minId = -1L;
                    DataSource dataSource = this._jdbcManager.getDataSource();
                    String messageTable = this._jdbcManager.getMessageTable();
                    JdbcMessage jdbcMessage = this._jdbcManager.getJdbcMessage();
                    conn = dataSource.getConnection();
                    try {
                        MessageImpl msg;
                        int updateCount;
                        String sql = "SELECT m_id, msg_type, msg_id, delivered, body, header FROM " + messageTable + " WHERE ?<m_id AND queue=?" + "   AND consumer IS NULL AND ?<=expire" + " ORDER BY m_id";
                        PreparedStatement selectStmt = conn.prepareStatement(sql);
                        try {
                            selectStmt.setFetchSize(1);
                        }
                        catch (Throwable e) {
                            log.log(Level.FINER, e.toString(), e);
                        }
                        sql = isAutoAck ? "DELETE FROM " + messageTable + " WHERE m_id=? AND consumer IS NULL" : "UPDATE " + messageTable + " SET consumer=?, delivered=1" + " WHERE m_id=? AND consumer IS NULL";
                        PreparedStatement updateStmt = conn.prepareStatement(sql);
                        long id = -1L;
                        do {
                            id = -1L;
                            selectStmt.setLong(1, minId);
                            selectStmt.setInt(2, this.getId());
                            selectStmt.setLong(3, Alarm.getCurrentTime());
                            msg = null;
                            ResultSet rs = selectStmt.executeQuery();
                            if (rs.next()) {
                                minId = id = rs.getLong(1);
                                msg = jdbcMessage.readMessage(rs);
                            }
                            rs.close();
                            if (msg == null) {
                                messageImpl2 = null;
                                Object var18_18 = null;
                                break block11;
                            }
                            if (isAutoAck) {
                                updateStmt.setLong(1, id);
                                continue;
                            }
                            updateStmt.setLong(1, this._consumerId);
                            updateStmt.setLong(2, id);
                        } while ((updateCount = updateStmt.executeUpdate()) != 1);
                        messageImpl = msg;
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var18_20 = null;
                        conn.close();
                        throw throwable;
                    }
                }
                conn.close();
                return messageImpl2;
            }
            Object var18_19 = null;
            conn.close();
            return messageImpl;
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
        catch (SQLException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public void commit(int session) throws JMSException {
    }

    protected int createDestination(String name, boolean isTopic) throws SQLException {
        block12: {
            ResultSet rs;
            PreparedStatement pstmt;
            String sql;
            String destinationTable;
            Connection conn;
            block11: {
                String destinationSequence;
                block10: {
                    int n;
                    conn = this._jdbcManager.getDataSource().getConnection();
                    destinationTable = this._jdbcManager.getDestinationTable();
                    destinationSequence = this._jdbcManager.getDestinationSequence();
                    try {
                        sql = "SELECT id FROM " + destinationTable + " WHERE name=? AND is_topic=?";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, name);
                        pstmt.setInt(2, isTopic ? 1 : 0);
                        rs = pstmt.executeQuery();
                        if (!rs.next()) break block10;
                        n = rs.getInt(1);
                        Object var13_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        conn.close();
                        throw throwable;
                    }
                    conn.close();
                    return n;
                }
                rs.close();
                if (destinationSequence == null) break block11;
                JdbcMetaData metaData = this._jdbcManager.getMetaData();
                sql = metaData.selectSequenceSQL(destinationSequence);
                int id = 0;
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    throw new RuntimeException("can't create sequence");
                }
                id = rs.getInt(1);
                sql = "INSERT INTO " + destinationTable + " (id,name,is_topic) VALUES(?,?,?)";
                pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, id);
                pstmt.setString(2, name);
                pstmt.setInt(3, isTopic ? 1 : 0);
                pstmt.executeUpdate();
                if (isTopic) {
                    log.fine("JMSTopic[" + name + "," + id + "] created");
                } else {
                    log.fine("JMSQueue[" + name + "," + id + "] created");
                }
                int n = id;
                Object var13_13 = null;
                conn.close();
                return n;
            }
            sql = "INSERT INTO " + destinationTable + " (name,is_topic) VALUES(?,?)";
            pstmt = conn.prepareStatement(sql, 1);
            pstmt.setString(1, name);
            pstmt.setInt(2, isTopic ? 1 : 0);
            pstmt.executeUpdate();
            rs = pstmt.getGeneratedKeys();
            if (!rs.next()) break block12;
            int id = rs.getInt(1);
            if (isTopic) {
                log.fine("JMSTopic[" + name + "," + id + "] created");
            } else {
                log.fine("JMSQueue[" + name + "," + id + "] created");
            }
            int n = id;
            Object var13_14 = null;
            conn.close();
            return n;
        }
        throw new SQLException(L.l("can't generate destination for {0}", (Object)name));
    }

    protected void purgeExpiredMessages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollImpl() {
        boolean hasValue = false;
        try {
            long minId = -1L;
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            JdbcMessage jdbcMessage = this._jdbcManager.getJdbcMessage();
            Connection conn = dataSource.getConnection();
            try {
                String sql = "SELECT m_id FROM " + messageTable + " WHERE ?<m_id AND queue=?" + "   AND consumer IS NULL AND ?<=expire" + " ORDER BY m_id";
                PreparedStatement selectStmt = conn.prepareStatement(sql);
                try {
                    selectStmt.setFetchSize(1);
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                selectStmt.setLong(1, minId);
                selectStmt.setInt(2, this.getId());
                selectStmt.setLong(3, Alarm.getCurrentTime());
                Object msg = null;
                ResultSet rs = selectStmt.executeQuery();
                if (rs.next()) {
                    hasValue = true;
                }
                rs.close();
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                conn.close();
                throw throwable;
            }
            conn.close();
            {
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (hasValue) {
            this.notifyMessageAvailable();
        }
    }

    public String toString() {
        return "JdbcQueue[" + this.getName() + "]";
    }
}

