/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.memory;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.queue.AbstractQueue;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryQueue
extends AbstractQueue {
    private static final Logger log = Logger.getLogger(MemoryQueue.class.getName());
    private ArrayList<MessageImpl> _queueList = new ArrayList();
    private ArrayList<MessageImpl> _readList = new ArrayList();

    @Override
    public String getUrl() {
        return "memory:name=" + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueueSize() {
        ArrayList<MessageImpl> arrayList = this._queueList;
        synchronized (arrayList) {
            return this._queueList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(JmsSession session, MessageImpl msg, long expires) {
        ArrayList<MessageImpl> arrayList = this._queueList;
        synchronized (arrayList) {
            this._queueList.add(msg);
        }
        this.notifyMessageAvailable();
    }

    @Override
    public boolean hasMessage() {
        return this._queueList.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageImpl receive(boolean isAutoAck) {
        ArrayList<MessageImpl> arrayList = this._queueList;
        synchronized (arrayList) {
            if (this._queueList.size() == 0) {
                return null;
            }
            MessageImpl msg = this._queueList.remove(0);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " receive " + msg + (isAutoAck ? " (auto-ack)" : ""));
            }
            if (isAutoAck) {
                return msg;
            }
            this._readList.add(msg);
            return msg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<MessageImpl> getBrowserList() {
        ArrayList<MessageImpl> arrayList = this._queueList;
        synchronized (arrayList) {
            return new ArrayList<MessageImpl>(this._queueList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledge(String msgId) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " acknowledge " + msgId);
        }
        ArrayList<MessageImpl> arrayList = this._queueList;
        synchronized (arrayList) {
            for (int i = this._readList.size() - 1; i >= 0; --i) {
                MessageImpl msg = this._readList.get(i);
                if (!msg.getJMSMessageID().equals(msgId)) continue;
                this._readList.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(String msgId) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " rollback " + msgId);
        }
        ArrayList<MessageImpl> arrayList = this._queueList;
        synchronized (arrayList) {
            for (int i = this._readList.size() - 1; i >= 0; --i) {
                MessageImpl msg = this._readList.get(i);
                if (!msg.getJMSMessageID().equals(msgId)) continue;
                this._readList.remove(i);
                msg.setJMSRedelivered(true);
                this._queueList.add(msg);
                this.notifyMessageAvailable();
            }
        }
    }
}

