/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.memory;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.memory.MemoryQueue;
import com.caucho.jms.memory.MemorySubscriberQueue;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.AbstractTopic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;

public class MemoryTopic
extends AbstractTopic {
    private static final Logger log = Logger.getLogger(MemoryTopic.class.getName());
    private HashMap<String, MemoryQueue> _durableSubscriptionMap = new HashMap();
    private ArrayList<AbstractQueue> _subscriptionList = new ArrayList();
    private int _id;

    public String getUrl() {
        return "memory:name=" + this.getName();
    }

    public AbstractQueue createSubscriber(JmsSession session, String name, boolean noLocal) {
        MemoryQueue queue;
        if (name != null) {
            queue = this._durableSubscriptionMap.get(name);
            if (queue == null) {
                queue = new MemorySubscriberQueue(session, noLocal);
                queue.setName(this.getName() + ":sub-" + name);
                this._subscriptionList.add(queue);
                this._durableSubscriptionMap.put(name, queue);
            }
        } else {
            queue = new MemorySubscriberQueue(session, noLocal);
            queue.setName(this.getName() + ":sub-" + this._id++);
            this._subscriptionList.add(queue);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " create-subscriber(" + queue + ")");
        }
        return queue;
    }

    public void closeSubscriber(AbstractQueue queue) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " close-subscriber(" + queue + ")");
        }
        if (!this._durableSubscriptionMap.values().contains(queue)) {
            this._subscriptionList.remove(queue);
        }
    }

    public void send(JmsSession session, MessageImpl msg, long timeout) throws JMSException {
        for (int i = 0; i < this._subscriptionList.size(); ++i) {
            this._subscriptionList.get(i).send(session, msg, timeout);
        }
    }
}

