/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.message;

import com.caucho.jms.JMSExceptionWrapper;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.MessageType;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;

public class BytesMessageImpl
extends MessageImpl
implements BytesMessage {
    private TempStream _tempStream;
    private ReadStream _rs;
    private WriteStream _ws;

    public BytesMessageImpl() {
    }

    BytesMessageImpl(BytesMessage bytes) throws JMSException {
        super((Message)bytes);
        bytes.reset();
        this.checkBodyWriteable();
        try {
            int sublen;
            TempBuffer tempBuf = TempBuffer.allocate();
            byte[] buffer = tempBuf.getBuffer();
            WriteStream out = this.getWriteStream();
            while ((sublen = bytes.readBytes(buffer, buffer.length)) > 0) {
                out.write(buffer, 0, sublen);
            }
            TempBuffer.free((TempBuffer)tempBuf);
            tempBuf = null;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            throw new JMSException(e.toString());
        }
        this.reset();
    }

    BytesMessageImpl(BytesMessageImpl bytes) throws JMSException {
        super(bytes);
        bytes.reset();
        this._tempStream = bytes._tempStream;
        this.reset();
    }

    public MessageType getType() {
        return MessageType.BYTES;
    }

    public void setReceive() throws JMSException {
        super.setReceive();
        this.reset();
    }

    public void reset() throws JMSException {
        this.setBodyReadOnly();
        try {
            if (this._ws != null) {
                this._ws.close();
            }
            if (this._tempStream != null) {
                if (this._rs != null) {
                    this._rs.close();
                }
                this._rs = this._tempStream.openReadAndSaveBuffer();
            }
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public boolean readBoolean() throws JMSException {
        ReadStream is = this.getReadStream();
        try {
            int value = is.read();
            if (value >= 0) {
                return value == 1;
            }
            throw new MessageEOFException("BytesMessage EOF");
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public byte readByte() throws JMSException {
        ReadStream is = this.getReadStream();
        try {
            int value = is.read();
            if (value >= 0) {
                return (byte)value;
            }
            throw new MessageEOFException("BytesMessage EOF");
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public int readUnsignedByte() throws JMSException {
        ReadStream is = this.getReadStream();
        if (is == null) {
            return -1;
        }
        try {
            int value = is.read();
            if (value >= 0) {
                return value;
            }
            throw new MessageEOFException("BytesMessage EOF");
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public short readShort() throws JMSException {
        ReadStream is = this.getReadStream();
        try {
            int d1 = is.read();
            int d2 = is.read();
            if (d2 >= 0) {
                return (short)((d1 << 8) + d2);
            }
            throw new MessageEOFException("BytesMessage EOF");
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public int readUnsignedShort() throws JMSException {
        ReadStream is = this.getReadStream();
        try {
            int d1 = is.read();
            int d2 = is.read();
            if (d2 >= 0) {
                return (d1 << 8) + d2;
            }
            throw new MessageEOFException("BytesMessage EOF");
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public int readInt() throws JMSException {
        ReadStream is = this.getReadStream();
        try {
            int d1 = is.read();
            int d2 = is.read();
            int d3 = is.read();
            int d4 = is.read();
            if (d4 >= 0) {
                return (d1 << 24) + (d2 << 16) + (d3 << 8) + d4;
            }
            throw new MessageEOFException("BytesMessage EOF");
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public long readLong() throws JMSException {
        ReadStream is = this.getReadStream();
        try {
            long d1 = is.read();
            long d2 = is.read();
            long d3 = is.read();
            long d4 = is.read();
            long d5 = is.read();
            long d6 = is.read();
            long d7 = is.read();
            long d8 = is.read();
            if (d8 >= 0L) {
                return (d1 << 56) + (d2 << 48) + (d3 << 40) + (d4 << 32) + (d5 << 24) + (d6 << 16) + (d7 << 8) + d8;
            }
            throw new MessageEOFException("BytesMessage EOF");
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public float readFloat() throws JMSException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws JMSException {
        return Double.longBitsToDouble(this.readLong());
    }

    public char readChar() throws JMSException {
        ReadStream is = this.getReadStream();
        try {
            int d1 = is.read();
            int d2 = is.read();
            if (d2 >= 0) {
                return (char)((d1 << 8) + d2);
            }
            throw new MessageEOFException("BytesMessage EOF");
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public String readUTF() throws JMSException {
        ReadStream is = this.getReadStream();
        CharBuffer cb = new CharBuffer();
        try {
            int len = this.readShort();
            while (len > 0) {
                int d2;
                int d1 = is.read();
                if (d1 < 128) {
                    cb.append((char)d1);
                    --len;
                    continue;
                }
                if ((d1 & 0xE0) == 192) {
                    d2 = is.read();
                    cb.append((char)(((d1 & 0x1F) << 6) + (d2 & 0x3F)));
                    len -= 2;
                    continue;
                }
                if ((d1 & 0xF0) == 224) {
                    d2 = is.read();
                    int d3 = is.read();
                    cb.append((char)(((d1 & 0xF) << 12) + ((d2 & 0x3F) << 6) + (d3 & 0x3F)));
                    len -= 3;
                    continue;
                }
                throw new MessageFormatException(L.l("invalid UTF-8 in bytes message"));
            }
        }
        catch (JMSException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JMSExceptionWrapper(e);
        }
        return cb.toString();
    }

    public int readBytes(byte[] value) throws JMSException {
        ReadStream is = this.getReadStream();
        try {
            return is.read(value);
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        ReadStream is = this.getReadStream();
        try {
            return is.read(value, 0, length);
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    protected ReadStream getReadStream() throws JMSException {
        this.checkBodyReadable();
        return this._rs;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this._ws = null;
        this._tempStream = null;
        this._rs = null;
    }

    public void writeBoolean(boolean b) throws JMSException {
        try {
            this.getWriteStream().write(b ? 1 : 0);
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public void writeByte(byte b) throws JMSException {
        try {
            this.getWriteStream().write((int)b);
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public void writeShort(short s) throws JMSException {
        try {
            WriteStream ws = this.getWriteStream();
            ws.write(s >> 8);
            ws.write((int)s);
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public void writeInt(int i) throws JMSException {
        try {
            WriteStream ws = this.getWriteStream();
            ws.write(i >> 24);
            ws.write(i >> 16);
            ws.write(i >> 8);
            ws.write(i);
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public void writeLong(long l) throws JMSException {
        try {
            WriteStream ws = this.getWriteStream();
            ws.write((int)(l >> 56));
            ws.write((int)(l >> 48));
            ws.write((int)(l >> 40));
            ws.write((int)(l >> 32));
            ws.write((int)(l >> 24));
            ws.write((int)(l >> 16));
            ws.write((int)(l >> 8));
            ws.write((int)l);
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public void writeFloat(float f) throws JMSException {
        int i = Float.floatToIntBits(f);
        this.writeInt(i);
    }

    public void writeDouble(double d) throws JMSException {
        long l = Double.doubleToLongBits(d);
        this.writeLong(l);
    }

    public void writeUTF(String s) throws JMSException {
        try {
            char ch;
            int i;
            WriteStream out = this.getWriteStream();
            int len = s.length();
            int byteLength = 0;
            for (i = 0; i < len; ++i) {
                ch = s.charAt(0);
                if (ch == '\u0000') {
                    byteLength += 2;
                    continue;
                }
                if (ch < '\u0080') {
                    ++byteLength;
                    continue;
                }
                if (ch < '\u0800') {
                    byteLength += 2;
                    continue;
                }
                byteLength += 3;
            }
            out.write(byteLength >> 8);
            out.write(byteLength);
            for (i = 0; i < len; ++i) {
                ch = s.charAt(i);
                if (ch == '\u0000') {
                    out.write(192);
                    out.write(128);
                    continue;
                }
                if (ch < '\u0080') {
                    out.write((int)ch);
                    continue;
                }
                if (ch < '\u0800') {
                    out.write(192 + (ch >> 6 & 0x1F));
                    out.write(128 + (ch & 0x3F));
                    continue;
                }
                if (ch >= '\u8000') continue;
                out.write(224 + (ch >> 12 & 0xF));
                out.write(128 + (ch >> 6 & 0x3F));
                out.write(128 + (ch & 0x3F));
            }
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public void writeChar(char ch) throws JMSException {
        try {
            WriteStream ws = this.getWriteStream();
            ws.write(ch >> 8);
            ws.write((int)ch);
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public void writeBytes(byte[] buf) throws JMSException {
        this.writeBytes(buf, 0, buf.length);
    }

    public void writeBytes(byte[] buf, int offset, int length) throws JMSException {
        try {
            WriteStream ws = this.getWriteStream();
            ws.write(buf, offset, length);
        }
        catch (IOException e) {
            throw new JMSExceptionWrapper(e);
        }
    }

    public void writeObject(Object obj) throws JMSException {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (obj instanceof Boolean) {
            this.writeBoolean((Boolean)obj);
        } else if (obj instanceof Byte) {
            this.writeByte((Byte)obj);
        } else if (obj instanceof Short) {
            this.writeShort((Short)obj);
        } else if (obj instanceof Character) {
            this.writeChar(((Character)obj).charValue());
        } else if (obj instanceof Integer) {
            this.writeInt((Integer)obj);
        } else if (obj instanceof Long) {
            this.writeLong((Long)obj);
        } else if (obj instanceof Float) {
            this.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Double) {
            this.writeDouble((Double)obj);
        } else if (obj instanceof String) {
            this.writeUTF((String)obj);
        } else if (obj instanceof byte[]) {
            this.writeBytes((byte[])obj);
        } else {
            throw new MessageFormatException(obj.getClass().getName() + ": " + String.valueOf(obj));
        }
    }

    public long getBodyLength() throws JMSException {
        this.checkBodyReadable();
        if (this._tempStream == null) {
            return 0L;
        }
        return this._tempStream.getLength();
    }

    protected WriteStream getWriteStream() throws JMSException {
        this.checkBodyWriteable();
        if (this._tempStream == null) {
            this._tempStream = new TempStream();
        }
        if (this._ws == null) {
            this._ws = new WriteStream((StreamImpl)this._tempStream);
        }
        return this._ws;
    }

    public MessageImpl copy() {
        try {
            return new BytesMessageImpl(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void copy(BytesMessageImpl newMsg) {
        super.copy(newMsg);
        try {
            if (this._ws != null) {
                this._ws.flush();
            }
            if (this._tempStream != null) {
                newMsg._tempStream = this._tempStream.copy();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public InputStream bodyToInputStream() throws IOException {
        if (this._tempStream != null) {
            return this._tempStream.openReadAndSaveBuffer();
        }
        return null;
    }

    public void readBody(InputStream is) throws IOException, JMSException {
        if (is != null) {
            WriteStream out = this.getWriteStream();
            out.writeStream(is);
            out.close();
        }
        this.reset();
    }

    public String toString() {
        return "BytesMessageImpl[]";
    }
}

