/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.message;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.MessageType;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

public class TextMessageImpl
extends MessageImpl
implements TextMessage {
    private String _text;

    public TextMessageImpl() {
    }

    public TextMessageImpl(TextMessage msg) throws JMSException {
        super((Message)msg);
        this._text = msg.getText();
    }

    public TextMessageImpl(TextMessageImpl msg) {
        super(msg);
        this._text = msg._text;
    }

    public MessageType getType() {
        return MessageType.TEXT;
    }

    public String getText() throws JMSException {
        return this._text;
    }

    public void setText(String text) throws JMSException {
        this.checkBodyWriteable();
        this._text = text;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this._text = null;
    }

    public MessageImpl copy() {
        return new TextMessageImpl(this);
    }

    protected void copy(TextMessageImpl newMsg) {
        super.copy(newMsg);
        newMsg._text = this._text;
    }

    public InputStream bodyToInputStream() throws IOException {
        if (this._text == null) {
            return null;
        }
        TempStream body = new TempStream();
        body.openWrite();
        WriteStream ws = new WriteStream((StreamImpl)body);
        this.writeBody((OutputStream)ws);
        ws.close();
        return body.openRead();
    }

    public void writeBody(OutputStream os) throws IOException {
        if (this._text == null) {
            return;
        }
        Hessian2Output out = new Hessian2Output(os);
        out.writeString(this._text);
        out.close();
    }

    public void readBody(InputStream is) throws IOException, JMSException {
        if (is == null) {
            return;
        }
        Hessian2Input in = new Hessian2Input(is);
        this._text = in.readString();
        in.close();
    }
}

