/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.queue;

import com.caucho.jms.JmsRuntimeException;
import com.caucho.jms.connection.ConnectionFactoryImpl;
import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.connection.MessageConsumerImpl;
import com.caucho.jms.message.MessageFactory;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.queue.DestinationHandle;
import com.caucho.jms.queue.MessageAvailableListener;
import com.caucho.util.Alarm;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import com.caucho.webbeans.component.HandleAware;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;

public abstract class AbstractDestination
extends AbstractQueue
implements Destination,
BlockingQueue,
Serializable,
HandleAware {
    private static final L10N L = new L10N(AbstractDestination.class);
    private static final Logger log = Logger.getLogger(AbstractDestination.class.getName());
    private static long _idRandom;
    private static long _idCount;
    private String _name = "default";
    protected MessageFactory _messageFactory = new MessageFactory();
    private ConnectionFactoryImpl _connectionFactory;
    private Connection _conn;
    private Object _readLock = new Object();
    private Object _writeLock = new Object();
    private JmsSession _writeSession;
    private JmsSession _readSession;
    private MessageConsumerImpl _consumer;
    private Object _serializationHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractDestination() {
        Class<AbstractDestination> clazz = AbstractDestination.class;
        synchronized (AbstractDestination.class) {
            if (_idRandom == 0L || Alarm.isTest()) {
                _idRandom = RandomUtil.getRandomLong();
                _idCount = Alarm.getCurrentTime() << 16;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getQueueName() {
        return this.getName();
    }

    public String getTopicName() {
        return this.getName();
    }

    public void setSerializationHandle(Object handle) {
        this._serializationHandle = handle;
    }

    public String getUrl() {
        return this.getClass().getSimpleName() + ":";
    }

    public void addMessageAvailableListener(MessageAvailableListener consumer) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void removeMessageAvailableListener(MessageAvailableListener consumer) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public abstract void send(JmsSession var1, MessageImpl var2, long var3) throws JMSException;

    public MessageImpl receive(boolean isAutoAcknowledge) throws JMSException {
        return null;
    }

    public boolean hasMessage() {
        return false;
    }

    public void acknowledge(String msgId) {
    }

    public void rollback(String msgId) {
    }

    public final String generateMessageID() {
        StringBuilder cb = new StringBuilder();
        cb.append("ID:");
        this.generateMessageID(cb);
        return cb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateMessageID(StringBuilder cb) {
        Class<AbstractDestination> clazz = AbstractDestination.class;
        synchronized (AbstractDestination.class) {
            long id = _idCount++;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            Base64.encode((StringBuilder)cb, (long)_idRandom);
            Base64.encode((StringBuilder)cb, (long)id);
            return;
        }
    }

    public Destination getJMSDestination() {
        return new DestinationHandle(this.toString());
    }

    public int size() {
        return 0;
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object value, long timeout, TimeUnit unit) {
        try {
            Object object = this._writeLock;
            synchronized (object) {
                JmsSession session = this.getWriteSession();
                Object msg = value instanceof Message ? (Message)value : session.createObjectMessage((Serializable)value);
                session.send(this, (Message)msg, 0, 0, Integer.MAX_VALUE);
                return true;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmsRuntimeException(e);
        }
    }

    public Object poll(long timeout, TimeUnit unit) {
        try {
            Object object = this._readLock;
            synchronized (object) {
                MessageConsumerImpl consumer = this.getReadConsumer();
                long msTimeout = unit.toMillis(timeout);
                Message msg = consumer.receive(msTimeout);
                if (msg instanceof ObjectMessage) {
                    return ((ObjectMessage)msg).getObject();
                }
                if (msg instanceof TextMessage) {
                    return ((TextMessage)msg).getText();
                }
                if (msg == null) {
                    return null;
                }
                throw new JmsRuntimeException(L.l("'{0}' is an unsupported message for the BlockingQueue API.", (Object)msg));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JmsRuntimeException(e);
        }
    }

    public boolean offer(Object value) {
        return this.offer(value, 0L, TimeUnit.SECONDS);
    }

    public void put(Object value) {
        this.offer(value, (long)Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    public Object peek() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Object poll() {
        return this.poll(0L, TimeUnit.MILLISECONDS);
    }

    public Object take() {
        return this.poll(Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    public int drainTo(Collection c) {
        throw new UnsupportedOperationException();
    }

    public int drainTo(Collection c, int max) {
        throw new UnsupportedOperationException();
    }

    protected JmsSession getWriteSession() throws JMSException {
        if (this._conn == null) {
            this._connectionFactory = new ConnectionFactoryImpl();
            this._conn = this._connectionFactory.createConnection();
            this._conn.start();
        }
        if (this._writeSession == null) {
            this._writeSession = (JmsSession)this._conn.createSession(false, 1);
        }
        return this._writeSession;
    }

    protected MessageConsumerImpl getReadConsumer() throws JMSException {
        if (this._conn == null) {
            this._connectionFactory = new ConnectionFactoryImpl();
            this._conn = this._connectionFactory.createConnection();
            this._conn.start();
        }
        if (this._readSession == null) {
            this._readSession = (JmsSession)this._conn.createSession(false, 1);
        }
        if (this._consumer == null) {
            this._consumer = (MessageConsumerImpl)this._readSession.createConsumer(this);
        }
        return this._consumer;
    }

    private Object writeReplace() {
        return this._serializationHandle;
    }

    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

