/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.queue;

import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.queue.AbstractDestination;
import com.caucho.jms.queue.MessageAvailableListener;
import com.caucho.jms.queue.QueueAdmin;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueue
extends AbstractDestination
implements Queue {
    private static final L10N L = new L10N(AbstractQueue.class);
    private static final Logger log = Logger.getLogger(AbstractQueue.class.getName());
    private QueueAdmin _admin;
    private ArrayList<MessageAvailableListener> _consumerList = new ArrayList();
    private int _roundRobin;
    private long _listenerFailCount;
    private long _listenerFailLastTime;

    protected AbstractQueue() {
    }

    public void setQueueName(String name) {
        this.setName(name);
    }

    public int getConsumerCount() {
        return this._consumerList.size();
    }

    public int getQueueSize() {
        return -1;
    }

    public long getListenerFailCountTotal() {
        return this._listenerFailCount;
    }

    public long getListenerFailLastTime() {
        return this._listenerFailLastTime;
    }

    public void init() {
    }

    @PostConstruct
    public void postConstruct() {
        this.init();
        this._admin = new QueueAdmin(this);
        this._admin.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageAvailableListener(MessageAvailableListener listener) {
        ArrayList<MessageAvailableListener> arrayList = this._consumerList;
        synchronized (arrayList) {
            if (!this._consumerList.contains(listener)) {
                this._consumerList.add(listener);
            }
            this.startPoll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageAvailableListener(MessageAvailableListener consumer) {
        ArrayList<MessageAvailableListener> arrayList = this._consumerList;
        synchronized (arrayList) {
            this._consumerList.remove(consumer);
            for (int i = 0; i < this._consumerList.size(); ++i) {
                this._consumerList.get(i).notifyMessageAvailable();
            }
            if (this._consumerList.size() == 0) {
                this.stopPoll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyMessageAvailable() {
        ArrayList<MessageAvailableListener> arrayList = this._consumerList;
        synchronized (arrayList) {
            if (this._consumerList.size() > 0) {
                int roundRobin;
                MessageAvailableListener consumer;
                int count = this._consumerList.size();
                while (!(consumer = this._consumerList.get(roundRobin = this._roundRobin++ % this._consumerList.size())).notifyMessageAvailable() && count-- > 0) {
                }
            }
        }
    }

    public ArrayList<MessageImpl> getBrowserList() {
        return new ArrayList<MessageImpl>();
    }

    protected void startPoll() {
    }

    protected void stopPoll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListenerException(Exception e) {
        AbstractQueue abstractQueue = this;
        synchronized (abstractQueue) {
            ++this._listenerFailCount;
            this._listenerFailLastTime = Alarm.getCurrentTime();
        }
    }

    @Override
    @PreDestroy
    public void close() {
        this.stopPoll();
        super.close();
    }
}

