/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.selector;

import com.caucho.jms.selector.Selector;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;

public class BooleanBinarySelector
extends Selector {
    private int _token;
    private Selector _left;
    private Selector _right;

    BooleanBinarySelector(int token, Selector left, Selector right) throws JMSException {
        this._token = token;
        this._left = left;
        this._right = right;
        switch (this._token) {
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                if (!this._left.isUnknown() && !this._left.isNumber()) {
                    throw new InvalidSelectorException(L.l("'{0}' must have a numeric value for comparison.", (Object)this));
                }
                if (this._right.isUnknown() || this._right.isNumber()) break;
                throw new InvalidSelectorException(L.l("'{0}' must have a numeric value for comparison.", (Object)this));
            }
            case 9: 
            case 10: {
                if (this._left.isUnknown() || this._right.isUnknown() || this._left.isNumber() == this._right.isNumber()) break;
                throw new InvalidSelectorException(L.l("'{0}' test must have matching types.", (Object)this));
            }
            case 16: 
            case 17: {
                if (!this._left.isUnknown() && !this._left.isBoolean()) {
                    throw new InvalidSelectorException(L.l("'{0}' must have a numeric value for comparison.", (Object)this));
                }
                if (this._right.isUnknown() || this._right.isBoolean()) break;
                throw new InvalidSelectorException(L.l("'{0}' must have a numeric value for comparison.", (Object)this));
            }
        }
    }

    boolean isBoolean() {
        return true;
    }

    boolean isUnknown() {
        return false;
    }

    public Object evaluate(Message message) throws JMSException {
        Object lvalue = this._left.evaluate(message);
        Object rvalue = this._right.evaluate(message);
        if (lvalue == null || rvalue == null) {
            return NULL;
        }
        switch (this._token) {
            case 9: {
                if (lvalue instanceof Number && rvalue instanceof Number) {
                    return BooleanBinarySelector.toBoolean(((Number)lvalue).doubleValue() == ((Number)rvalue).doubleValue());
                }
                return BooleanBinarySelector.toBoolean(lvalue.equals(rvalue));
            }
            case 10: {
                if (lvalue instanceof Number && rvalue instanceof Number) {
                    return BooleanBinarySelector.toBoolean(((Number)lvalue).doubleValue() != ((Number)rvalue).doubleValue());
                }
                return BooleanBinarySelector.toBoolean(!lvalue.equals(rvalue));
            }
            case 11: {
                if (lvalue instanceof Number && rvalue instanceof Number) {
                    return BooleanBinarySelector.toBoolean(((Number)lvalue).doubleValue() < ((Number)rvalue).doubleValue());
                }
                return Boolean.FALSE;
            }
            case 12: {
                if (lvalue instanceof Number && rvalue instanceof Number) {
                    return BooleanBinarySelector.toBoolean(((Number)lvalue).doubleValue() <= ((Number)rvalue).doubleValue());
                }
                return Boolean.FALSE;
            }
            case 13: {
                if (lvalue instanceof Number && rvalue instanceof Number) {
                    return BooleanBinarySelector.toBoolean(((Number)lvalue).doubleValue() > ((Number)rvalue).doubleValue());
                }
                return Boolean.FALSE;
            }
            case 14: {
                if (lvalue instanceof Number && rvalue instanceof Number) {
                    return BooleanBinarySelector.toBoolean(((Number)lvalue).doubleValue() >= ((Number)rvalue).doubleValue());
                }
                return Boolean.FALSE;
            }
            case 16: {
                if (!(lvalue instanceof Boolean)) {
                    return NULL;
                }
                if (!((Boolean)lvalue).booleanValue()) {
                    return Boolean.FALSE;
                }
                if (!(rvalue instanceof Boolean)) {
                    return NULL;
                }
                if (!((Boolean)rvalue).booleanValue()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case 17: {
                if (lvalue instanceof Boolean && ((Boolean)lvalue).booleanValue()) {
                    return Boolean.TRUE;
                }
                if (rvalue instanceof Boolean && ((Boolean)rvalue).booleanValue()) {
                    return Boolean.TRUE;
                }
                if (lvalue instanceof Boolean || rvalue instanceof Boolean) {
                    return Boolean.FALSE;
                }
                return NULL;
            }
        }
        throw new JMSException("NOTONE");
    }

    public String toString() {
        switch (this._token) {
            case 9: {
                return this._left + " = " + this._right;
            }
            case 10: {
                return this._left + " <> " + this._right;
            }
            case 11: {
                return this._left + " < " + this._right;
            }
            case 12: {
                return this._left + " <= " + this._right;
            }
            case 13: {
                return this._left + " > " + this._right;
            }
            case 14: {
                return this._left + " >= " + this._right;
            }
            case 16: {
                return this._left + " AND " + this._right;
            }
            case 17: {
                return this._left + " OR " + this._right;
            }
        }
        return super.toString();
    }
}

