/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.selector;

import com.caucho.jms.selector.BetweenSelector;
import com.caucho.jms.selector.BooleanBinarySelector;
import com.caucho.jms.selector.BooleanLiteralSelector;
import com.caucho.jms.selector.IdentifierSelector;
import com.caucho.jms.selector.InSelector;
import com.caucho.jms.selector.LikeSelector;
import com.caucho.jms.selector.LiteralSelector;
import com.caucho.jms.selector.NumericBinarySelector;
import com.caucho.jms.selector.OrSelector;
import com.caucho.jms.selector.Selector;
import com.caucho.jms.selector.UnarySelector;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class SelectorParser {
    static final Logger log = Log.open(SelectorParser.class);
    static final L10N L = new L10N(SelectorParser.class);
    static final int TRUE = 1;
    static final int FALSE = 2;
    static final int NULL = 3;
    static final int INTEGER = 4;
    static final int DOUBLE = 5;
    static final int LONG = 6;
    static final int STRING = 7;
    static final int IDENTIFIER = 8;
    static final int EQ = 9;
    static final int NE = 10;
    static final int LT = 11;
    static final int LE = 12;
    static final int GT = 13;
    static final int GE = 14;
    static final int NOT = 15;
    static final int AND = 16;
    static final int OR = 17;
    static final int BETWEEN = 18;
    static final int LIKE = 19;
    static final int ESCAPE = 20;
    static final int IN = 21;
    static final int IS = 22;
    private static IntMap _reserved = new IntMap();
    private String _query;
    private int _parseIndex;
    private int _token = -1;
    private String _lexeme;
    private CharBuffer _cb = new CharBuffer();

    public Selector parse(String query) throws JMSException {
        this._query = query;
        this._parseIndex = 0;
        if (this.peekToken() == -1) {
            return null;
        }
        Selector selector = this.parseExpr();
        if (!selector.isUnknown() && !selector.isBoolean()) {
            throw new InvalidSelectorException(L.l("selector '{0}' must be a boolean", (Object)selector));
        }
        return selector;
    }

    private Selector parseExpr() throws JMSException {
        return this.parseOr();
    }

    private Selector parseOr() throws JMSException {
        Selector left = this.parseAnd();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 17: {
                    this.scanToken();
                    left = new OrSelector(left, this.parseAnd());
                    continue block3;
                }
            }
            break;
        }
        return left;
    }

    private Selector parseAnd() throws JMSException {
        Selector left = this.parseCmp();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 16: {
                    this.scanToken();
                    left = new BooleanBinarySelector(token, left, this.parseCmp());
                    continue block3;
                }
            }
            break;
        }
        return left;
    }

    private Selector parseCmp() throws JMSException {
        int token = this.peekToken();
        boolean isNot = false;
        if (token == 15) {
            this.scanToken();
            isNot = true;
            token = this.peekToken();
        }
        Selector left = this.parseAdd();
        token = this.peekToken();
        if (token == 15) {
            isNot = !isNot;
            this.scanToken();
            token = this.peekToken();
        }
        if (token >= 9 && token <= 14) {
            this.scanToken();
            left = new BooleanBinarySelector(token, left, this.parseAdd());
        } else if (token == 18) {
            this.scanToken();
            Selector low = this.parseAdd();
            token = this.scanToken();
            if (token != 16) {
                throw this.error("BETWEEN needs AND");
            }
            Selector high = this.parseAdd();
            left = new BetweenSelector(left, low, high);
        } else if (token == 19) {
            this.scanToken();
            token = this.scanToken();
            if (token != 7) {
                throw this.error("LIKE needs string pattern");
            }
            String pattern = this._lexeme;
            char escape = '\\';
            if (this.peekToken() == 20) {
                this.scanToken();
                token = this.scanToken();
                if (token != 7) {
                    throw this.error("ESCAPE needs string pattern");
                }
                if (this._lexeme.length() > 0) {
                    escape = this._lexeme.charAt(0);
                }
            }
            left = new LikeSelector(left, pattern, escape);
        } else if (token == 21) {
            this.scanToken();
            InSelector inSelector = new InSelector(left);
            if (this.scanToken() != 40) {
                throw this.error("IN needs `('");
            }
            while ((token = this.scanToken()) == 7) {
                inSelector.addValue(this._lexeme);
                if (this.peekToken() != 44) continue;
                this.scanToken();
            }
            if (token != 41) {
                throw this.error("IN needs `)'");
            }
            this.scanToken();
            left = inSelector;
        } else if (token == 22) {
            this.scanToken();
            if (this.peekToken() == 15) {
                isNot = !isNot;
                this.scanToken();
            }
            if ((token = this.scanToken()) != 3) {
                throw this.error("IS needs NULL");
            }
            left = new UnarySelector(3, left);
        }
        if (isNot) {
            return new UnarySelector(15, left);
        }
        return left;
    }

    private Selector parseAdd() throws JMSException {
        Selector left = this.parseMul();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 43: 
                case 45: {
                    this.scanToken();
                    left = new NumericBinarySelector(token, left, this.parseMul());
                    continue block3;
                }
            }
            break;
        }
        return left;
    }

    private Selector parseMul() throws JMSException {
        Selector left = this.parseUnary();
        block3: while (true) {
            int token = this.peekToken();
            switch (token) {
                case 42: 
                case 47: {
                    this.scanToken();
                    left = new NumericBinarySelector(token, left, this.parseUnary());
                    continue block3;
                }
            }
            break;
        }
        return left;
    }

    private Selector parseUnary() throws JMSException {
        int token = this.peekToken();
        switch (token) {
            case 43: {
                this.scanToken();
                return new UnarySelector(token, this.parseUnary());
            }
            case 45: {
                this.scanToken();
                return new UnarySelector(45, this.parseUnary());
            }
        }
        return this.parseTerm(false);
    }

    private Selector parseTerm(boolean hasSign) throws JMSException {
        Selector value = null;
        int token = this.scanToken();
        switch (token) {
            case 1: {
                value = new BooleanLiteralSelector(true);
                break;
            }
            case 2: {
                value = new BooleanLiteralSelector(false);
                break;
            }
            case 8: {
                value = IdentifierSelector.create(this._lexeme);
                break;
            }
            case 7: {
                value = new LiteralSelector(this._lexeme);
                break;
            }
            case 4: {
                if (hasSign) {
                    return new LiteralSelector(Long.decode("-" + this._lexeme));
                }
                return new LiteralSelector(Long.decode(this._lexeme));
            }
            case 6: {
                if (hasSign) {
                    return new LiteralSelector(Long.decode("-" + this._lexeme));
                }
                return new LiteralSelector(Long.decode(this._lexeme));
            }
            case 5: {
                if (hasSign) {
                    return new LiteralSelector(new Double("-" + this._lexeme));
                }
                return new LiteralSelector(new Double(this._lexeme));
            }
            case 40: {
                value = this.parseExpr();
                if (this.scanToken() == 41) break;
                throw this.error("expected ')'");
            }
            default: {
                throw this.error("unknown token: " + token);
            }
        }
        if (hasSign) {
            return new UnarySelector(45, value);
        }
        return value;
    }

    private int peekToken() throws JMSException {
        if (this._token > 0) {
            return this._token;
        }
        this._token = this.scanToken();
        return this._token;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int scanToken() throws JMSException {
        if (this._token > 0) {
            int value = this._token;
            this._token = -1;
            return value;
        }
        int sign = 1;
        int ch = this.read();
        while (Character.isWhitespace((char)ch)) {
            ch = this.read();
        }
        switch (ch) {
            case -1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: {
                return ch;
            }
            case 61: {
                return 9;
            }
            case 60: {
                ch = this.read();
                if (ch == 61) {
                    return 12;
                }
                if (ch == 62) {
                    return 10;
                }
                this.unread(ch);
                return 11;
            }
            case 62: {
                ch = this.read();
                if (ch == 61) {
                    return 14;
                }
                this.unread(ch);
                return 13;
            }
        }
        if (Character.isJavaIdentifierStart((char)ch)) {
            this._cb.clear();
            while (ch > 0 && Character.isJavaIdentifierPart((char)ch)) {
                this._cb.append((char)ch);
                ch = this.read();
            }
            this.unread(ch);
            this._lexeme = this._cb.toString();
            String lower = this._lexeme.toLowerCase();
            int token = _reserved.get((Object)lower);
            if (token > 0) {
                return token;
            }
            return 8;
        }
        if (ch >= 48 && ch <= 57 || ch == 46) {
            this._cb.clear();
            int type = 4;
            if (sign < 0) {
                this._cb.append('-');
            }
            while (48 <= ch && ch <= 57) {
                this._cb.append((char)ch);
                ch = this.read();
            }
            if ((ch == 120 || ch == 88) && this._cb.length() == 1 && this._cb.charAt(0) == '0') {
                this._cb.append('x');
                ch = this.read();
                while (48 <= ch && ch <= 57 || 97 <= ch && ch <= 102 || 65 <= ch && ch <= 70) {
                    this._cb.append((char)ch);
                    ch = this.read();
                }
                this._lexeme = this._cb.toString();
                if (ch != 108 && ch != 76) {
                    this.unread(ch);
                    return 4;
                }
                return 6;
            }
            if (ch == 46) {
                type = 5;
                this._cb.append('.');
                ch = this.read();
                while (ch >= 48 && ch <= 57) {
                    this._cb.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 101 || ch == 69) {
                type = 5;
                this._cb.append('e');
                ch = this.read();
                if (ch == 43 || ch == 45) {
                    this._cb.append((char)ch);
                    ch = this.read();
                }
                if (ch < 48 || ch > 57) {
                    throw this.error(L.l("exponent needs digits at {0}", (Object)this.charName(ch)));
                }
                while (ch >= 48 && ch <= 57) {
                    this._cb.append((char)ch);
                    ch = this.read();
                }
            }
            if (ch == 70 || ch == 68 || ch == 102 || ch == 100) {
                type = 5;
            } else if (ch == 76 || ch == 108) {
                type = 6;
            } else {
                this.unread(ch);
            }
            this._lexeme = this._cb.toString();
            return type;
        }
        if (ch != 39) {
            throw this.error(L.l("unexpected char at {0}", (Object)("" + (char)ch)));
        }
        int end = ch;
        this._cb.clear();
        ch = this.read();
        while (ch >= 0) {
            block36: {
                if (ch == end) {
                    int ch1 = this.read();
                    if (ch1 == end) {
                        this._cb.append((char)end);
                        break block36;
                    } else {
                        this.unread(ch1);
                        break;
                    }
                }
                this._cb.append((char)ch);
            }
            ch = this.read();
        }
        if (ch < 0) {
            throw this.error(L.l("unexpected end of selector"));
        }
        this._lexeme = this._cb.toString();
        return 7;
    }

    private int read() {
        if (this._parseIndex < this._query.length()) {
            return this._query.charAt(this._parseIndex++);
        }
        return -1;
    }

    private void unread(int ch) {
        if (ch >= 0) {
            --this._parseIndex;
        }
    }

    public JMSException error(String msg) {
        msg = msg + "\nin \"" + this._query + "\"";
        return new InvalidSelectorException(msg);
    }

    private String charName(int ch) {
        if (ch < 0) {
            return L.l("end of query");
        }
        return String.valueOf((char)ch);
    }

    static {
        _reserved.put((Object)"true", 1);
        _reserved.put((Object)"false", 2);
        _reserved.put((Object)"and", 16);
        _reserved.put((Object)"or", 17);
        _reserved.put((Object)"not", 15);
        _reserved.put((Object)"null", 3);
        _reserved.put((Object)"is", 22);
        _reserved.put((Object)"in", 21);
        _reserved.put((Object)"like", 19);
        _reserved.put((Object)"escape", 20);
        _reserved.put((Object)"between", 18);
    }
}

