/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.xmpp;

import com.caucho.jms.xmpp.BindStanza;
import com.caucho.jms.xmpp.EmptyStanza;
import com.caucho.jms.xmpp.IqErrorStanza;
import com.caucho.jms.xmpp.SessionStanza;
import com.caucho.jms.xmpp.Stanza;
import com.caucho.jms.xmpp.StreamStanza;
import com.caucho.jms.xmpp.SuccessStanza;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import com.caucho.util.ThreadPool;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SocketStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmppClient {
    private static final L10N L = new L10N(XmppClient.class);
    private static final Logger log = Logger.getLogger(XmppClient.class.getName());
    private static final String STREAMS_NS = "http://etherx.jabber.org/streams";
    private static final String AUTH = "auth{http://jabber.org/features/iq-auth}";
    private static final String REGISTER = "register{http://jabber.org/features/iq-register}";
    private InetAddress _address;
    private int _port;
    private String _to;
    private Socket _s;
    private ReadStream _is;
    private WriteStream _os;
    private String _id;
    private String _from;
    private XMLStreamReader _in;
    private boolean _isFinest;
    private int _mId;
    private HashSet<String> _authMechanisms = new HashSet();
    private HashSet<String> _features = new HashSet();
    private BlockingQueue<Stanza> _stanzaQueue = new LinkedBlockingQueue<Stanza>();

    public XmppClient(InetAddress address, int port) {
        this._address = address;
        this._port = port;
        this._to = this._address.getHostAddress();
        this._isFinest = log.isLoggable(Level.FINEST);
    }

    public XmppClient(String address, int port) {
        this(XmppClient.getByName(address), port);
        this._to = address;
    }

    private static InetAddress getByName(String address) {
        try {
            return InetAddress.getByName(address);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void connect() throws IOException {
        try {
            if (this._s != null) {
                throw new IllegalStateException(L.l("{0} is already connected", (Object)this));
            }
            this._s = new Socket(this._address, this._port);
            SocketStream ss = new SocketStream(this._s);
            this._os = new WriteStream((StreamImpl)ss);
            this._is = new ReadStream((StreamImpl)ss);
            this._os.print("<?xml version='1.0' encoding='UTF-8' ?>\n");
            this._os.setEncoding("utf-8");
            this.startStream();
            this._os.flush();
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this._in = factory.createXMLStreamReader((InputStream)this._is);
            String tag = this.readStartTag();
            if (!tag.equals("stream") || !STREAMS_NS.equals(this._in.getNamespaceURI())) {
                throw new IOExceptionWrapper(L.l("<{0}> with ns={1} is an unexpected server response", (Object)tag, (Object)this._in.getNamespaceURI()));
            }
            this.readStreamFeatures();
            ThreadPool.getThreadPool().start((Runnable)new Listener());
        }
        catch (XMLStreamException e) {
            throw new IOExceptionWrapper((Throwable)e);
        }
    }

    public void login(String name, String password) throws IOException {
        String base64 = Base64.encode((String)("\u0000" + name + '\u0000' + password));
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " authenticating " + name);
        }
        this._os.print("<auth xmlns='urn:ietf:params:xml:ns:xmpp-sasl' mechanism='PLAIN'>");
        this._os.print(base64);
        this._os.print("</auth>");
        this.startStream();
        this._os.flush();
        try {
            Stanza stanza = this._stanzaQueue.poll(2L, TimeUnit.SECONDS);
            if (!(stanza instanceof SuccessStanza)) {
                throw new RuntimeException("login failure");
            }
            stanza = this._stanzaQueue.poll(2L, TimeUnit.SECONDS);
            if (!(stanza instanceof StreamStanza)) {
                throw new RuntimeException("expected stream");
            }
            StringBuilder sb = new StringBuilder();
            Base64.encode((StringBuilder)sb, (long)RandomUtil.getRandomLong());
            this._os.print("<iq type='set' id='m_" + this._mId++ + "'>");
            this._os.print("<bind xmlns='urn:ietf:params:xml:ns:xmpp-bind'>");
            this._os.print("<resource>maryJane</resource>");
            this._os.print("</bind>");
            this._os.print("</iq>");
            this._os.flush();
            stanza = this._stanzaQueue.poll(2L, TimeUnit.SECONDS);
            if (!(stanza instanceof BindStanza)) {
                throw new RuntimeException("expected bind");
            }
            this._os.print("<iq type='set' id='m_" + this._mId++ + "'>");
            this._os.print("<session xmlns='urn:ietf:params:xml:ns:xmpp-session'/>");
            this._os.print("</iq>");
            this._os.flush();
            stanza = this._stanzaQueue.poll(2L, TimeUnit.SECONDS);
            if (!(stanza instanceof SessionStanza) && !(stanza instanceof EmptyStanza)) {
                throw new RuntimeException("expected session");
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(this + " authentication successful for " + name);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void roster() throws IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " roster");
        }
        try {
            this._os.print("<iq type='get' id='m_" + this._mId++ + "'>");
            this._os.print("<query xmlns='jabber:iq:roster'/>");
            this._os.print("</iq>");
            this._os.flush();
            Stanza stanza = this._stanzaQueue.poll(2L, TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void send(String type, String to, String body) throws IOException {
        this.send(type, to, body, null);
    }

    public void send(String type, String to, String body, String subject) throws IOException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " send to=" + to + " body=" + body);
        }
        try {
            this._os.print("<message ");
            this._os.print(" type='" + type + "'");
            if (to != null) {
                this._os.print(" to='" + to + "'");
            }
            if (this._from != null) {
                this._os.print(" from='" + this._from + "'");
            }
            this._os.print(">");
            if (subject != null) {
                this._os.print("<subject>" + subject + "</subject>");
            }
            if (body != null) {
                this._os.print("<body>" + body + "</body>");
            }
            this._os.print("</message>");
            this._os.flush();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void startStream() throws IOException {
        this._os.print("<stream:stream");
        this._os.print(" to='" + this._to + "'");
        this._os.print(" xmlns='jabber:client'");
        this._os.print(" xmlns:stream='http://etherx.jabber.org/streams'");
        this._os.print(" version='1.0'");
        this._os.print(">");
        this._os.flush();
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " <stream:stream xmlns='jabber:client' to='" + this._to + "'>");
        }
    }

    private void readStreamFeatures() throws IOException, XMLStreamException {
        String startTag = this.readStartTag();
        if (!"features".equals(startTag)) {
            throw this.unexpected();
        }
        int tag = 0;
        while (!((tag = this._in.next()) <= 0 || tag == 2 && "features".equals(this._in.getLocalName()))) {
            if (this._isFinest) {
                this.debug(this._in);
            }
            if (tag == 1) {
                String localName = this._in.getLocalName();
                if ("mechanisms".equals(localName)) continue;
                if ("mechanism".equals(localName)) {
                    tag = this._in.next();
                    String mechanism = this._in.getText();
                    this._authMechanisms.add(mechanism);
                    continue;
                }
                String feature = localName + "{" + this._in.getNamespaceURI() + "}";
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this + " feature " + feature);
                }
                this._features.add(feature);
                continue;
            }
            if (tag != 2) continue;
            String string = this._in.getLocalName();
        }
    }

    private String readStartTag() throws IOException, XMLStreamException {
        int tag = 0;
        while ((tag = this._in.next()) > 0 && tag != 1) {
            if (!this._isFinest) continue;
            this.debug(this._in);
        }
        if (this._isFinest) {
            this.debug(this._in);
        }
        return this._in.getLocalName();
    }

    private IOException unexpected() throws IOException, XMLStreamException {
        if ("error".equals(this._in.getLocalName())) {
            int tag;
            while (!((tag = this._in.next()) <= 0 || tag == 2 && "error".equals(this._in.getLocalName()))) {
                if (tag == 1) {
                    System.out.println("<" + this._in.getLocalName() + ">");
                    continue;
                }
                if (tag != 2) continue;
                System.out.println("</" + this._in.getLocalName() + ">");
            }
            return new IOException(L.l("<error> is unexpected", (Object)this._in.getLocalName()));
        }
        return new IOException(L.l("<{0}> is unexpected", (Object)this._in.getLocalName()));
    }

    public boolean isClosed() {
        return this._s == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " close");
        }
        try {
            WriteStream os;
            ReadStream is;
            Socket s;
            XmppClient xmppClient = this;
            synchronized (xmppClient) {
                s = this._s;
                this._s = null;
                is = this._is;
                this._is = null;
                os = this._os;
                this._os = null;
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (is != null) {
                is.close();
            }
            if (s != null) {
                s.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private void debug(XMLStreamReader in) throws IOException, XMLStreamException {
        if (1 == in.getEventType()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<");
            if (in.getPrefix() != null && !"".equals(in.getPrefix())) {
                sb.append(in.getPrefix()).append(":");
            }
            sb.append(in.getLocalName());
            if (in.getNamespaceURI() != null) {
                sb.append("{").append(in.getNamespaceURI()).append("}");
            }
            for (int i = 0; i < in.getAttributeCount(); ++i) {
                sb.append(" ");
                sb.append(in.getAttributeLocalName(i));
                sb.append("='");
                sb.append(in.getAttributeValue(i));
                sb.append("'");
            }
            sb.append(">");
            log.finest(this + " " + sb);
        } else if (2 == in.getEventType()) {
            log.finest(this + " </" + in.getLocalName() + ">");
        } else if (4 == in.getEventType()) {
            log.finest(this + " text='" + in.getText() + "'");
        } else {
            log.finest(this + " tag=" + in.getEventType());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._address + "," + this._port + "]";
    }

    protected void finalize() {
        this.close();
    }

    class Listener
    implements Runnable {
        private boolean _isFinest;

        Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._isFinest = log.isLoggable(Level.FINEST);
            try {
                try {
                    while (!XmppClient.this.isClosed()) {
                        this.readPacket();
                    }
                    Object var3_1 = null;
                    XmppClient.this.close();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var3_2 = null;
                    XmppClient.this.close();
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                XmppClient.this.close();
                throw throwable;
            }
        }

        private void readPacket() throws IOException, XMLStreamException {
            int tag;
            XMLStreamReader in = XmppClient.this._in;
            if (in == null) {
                return;
            }
            while ((tag = in.next()) > 0) {
                if (this._isFinest) {
                    XmppClient.this.debug(in);
                }
                if (tag == 1) {
                    String localName = in.getLocalName();
                    if ("success".equals(localName)) {
                        this.skipToEnd("success");
                        XmppClient.this._stanzaQueue.add(new SuccessStanza(in));
                        continue;
                    }
                    if ("stream".equals(localName)) {
                        XmppClient.this.readStreamFeatures();
                        XmppClient.this._stanzaQueue.add(new StreamStanza(in));
                        continue;
                    }
                    if ("iq".equals(localName)) {
                        XmppClient.this._stanzaQueue.add(this.readIq(in));
                        continue;
                    }
                    log.fine(XmppClient.this + " unknown tag <" + XmppClient.this._in.getLocalName() + ">");
                    XmppClient.this.close();
                    return;
                }
                if (tag != 2) continue;
                log.fine(XmppClient.this + " unexpected end </" + XmppClient.this._in.getLocalName() + ">");
                XmppClient.this.close();
                return;
            }
            if (tag < 0) {
                XmppClient.this.close();
            }
        }

        private Stanza readIq(XMLStreamReader in) throws IOException, XMLStreamException {
            String type = in.getAttributeValue(null, "type");
            if ("error".equals(type)) {
                this.skipToEnd("iq");
                return new IqErrorStanza(in);
            }
            if ("result".equals(type)) {
                String id = in.getAttributeValue(null, "id");
                int tag = in.nextTag();
                if (this._isFinest) {
                    XmppClient.this.debug(in);
                }
                if (tag == 2 && "iq".equals(in.getLocalName())) {
                    return new EmptyStanza();
                }
                if (tag != 1) {
                    throw new IllegalStateException("expected start");
                }
                String name = in.getLocalName();
                if ("bind".equals(name)) {
                    return this.readBind(in, id);
                }
                if ("session".equals(name)) {
                    this.skipToEnd("iq");
                    return new SessionStanza();
                }
                this.skipToEnd("iq");
                return new IqErrorStanza();
            }
            throw new UnsupportedOperationException(type);
        }

        private Stanza readBind(XMLStreamReader in, String id) throws IOException, XMLStreamException {
            BindStanza bind = new BindStanza();
            bind.setId(id);
            this.skipToEnd("bind");
            this.skipToEnd("iq");
            return bind;
        }

        private void skipToEnd(String tagName) throws IOException, XMLStreamException {
            int tag;
            XMLStreamReader in = XmppClient.this._in;
            if (in == null) {
                return;
            }
            while ((tag = in.next()) > 0) {
                if (this._isFinest) {
                    XmppClient.this.debug(in);
                }
                if (tag == 1 || tag != 2 || !tagName.equals(in.getLocalName())) continue;
                return;
            }
        }
    }
}

