/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.xmpp;

import com.caucho.jms.JmsConnectionFactory;
import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.xmpp.MessageStanza;
import com.caucho.jms.xmpp.XmppPubSubLeaf;
import com.caucho.jms.xmpp.XmppRequest;
import com.caucho.server.port.Protocol;
import com.caucho.server.port.ServerRequest;
import com.caucho.server.port.TcpConnection;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppProtocol
extends Protocol {
    private static final Logger log = Logger.getLogger(XmppProtocol.class.getName());
    private ClassLoader _loader;
    private HashMap<String, XmppPubSubLeaf> _pubSubMap = new HashMap();
    private ArrayList<XmppRequest> _clients = new ArrayList();
    private Connection _jmsConn;

    public XmppProtocol() {
        this.setProtocolName("xmpp");
        this._loader = Thread.currentThread().getContextClassLoader();
        try {
            this._jmsConn = new JmsConnectionFactory().createConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    ClassLoader getClassLoader() {
        return this._loader;
    }

    @PostConstruct
    public void init() {
        WebBeansContainer.create().addSingleton(this);
    }

    @Override
    public ServerRequest createRequest(com.caucho.server.connection.Connection connection) {
        return new XmppRequest(this, (TcpConnection)connection);
    }

    JmsSession createSession() {
        try {
            return (JmsSession)this._jmsConn.createSession(false, 1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmppPubSubLeaf createNode(String name) {
        HashMap<String, XmppPubSubLeaf> hashMap = this._pubSubMap;
        synchronized (hashMap) {
            XmppPubSubLeaf leaf = this._pubSubMap.get(name);
            if (leaf == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " create pub-sub node " + name);
                }
                leaf = new XmppPubSubLeaf(this, name);
                this._pubSubMap.put(name, leaf);
            }
            return leaf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmppPubSubLeaf getNode(String name) {
        HashMap<String, XmppPubSubLeaf> hashMap = this._pubSubMap;
        synchronized (hashMap) {
            return this._pubSubMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<XmppPubSubLeaf> getNodes() {
        ArrayList<XmppPubSubLeaf> nodes = new ArrayList<XmppPubSubLeaf>();
        HashMap<String, XmppPubSubLeaf> hashMap = this._pubSubMap;
        synchronized (hashMap) {
            nodes.addAll(this._pubSubMap.values());
            return nodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(XmppPubSubLeaf leaf, MessageImpl msg, long timeout) {
        MessageStanza stanza = new MessageStanza();
        try {
            Serializable value;
            if (msg instanceof TextMessage) {
                stanza.setBody(((TextMessage)msg).getText());
            } else if (msg instanceof ObjectMessage && (value = ((ObjectMessage)msg).getObject()) != null) {
                stanza.setBody(value.toString());
            }
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        System.out.println("STANZA: " + stanza + " " + this._clients);
        ArrayList<XmppRequest> arrayList = this._clients;
        synchronized (arrayList) {
            for (int i = 0; i < this._clients.size(); ++i) {
                XmppRequest client = this._clients.get(i);
                client.offer(client.getRequestId(), stanza);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClient(XmppRequest request) {
        ArrayList<XmppRequest> arrayList = this._clients;
        synchronized (arrayList) {
            this._clients.add(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClient(XmppRequest request) {
        ArrayList<XmppRequest> arrayList = this._clients;
        synchronized (arrayList) {
            this._clients.remove(request);
        }
    }
}

