/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.xmpp;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.memory.MemorySubscriberQueue;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.AbstractTopic;
import com.caucho.jms.xmpp.XmppProtocol;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;

public class XmppPubSubLeaf
extends AbstractTopic {
    private static final Logger log = Logger.getLogger(XmppPubSubLeaf.class.getName());
    private XmppProtocol _protocol;
    private ArrayList<AbstractQueue> _subscriptionList = new ArrayList();
    private int _id;

    public XmppPubSubLeaf(XmppProtocol protocol, String name) {
        this._protocol = protocol;
        this.setName(name);
    }

    public AbstractQueue createSubscriber(JmsSession session, String name, boolean noLocal) {
        MemorySubscriberQueue queue;
        if (name != null) {
            queue = new MemorySubscriberQueue(session, noLocal);
            queue.setName(this.getName() + ":sub-" + name);
            this._subscriptionList.add(queue);
        } else {
            queue = new MemorySubscriberQueue(session, noLocal);
            queue.setName(this.getName() + ":sub-" + this._id++);
            this._subscriptionList.add(queue);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " create-subscriber(" + queue + ")");
        }
        return queue;
    }

    public void closeSubscriber(AbstractQueue queue) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " close-subscriber(" + queue + ")");
        }
        this._subscriptionList.remove(queue);
    }

    public void send(JmsSession session, MessageImpl msg, long timeout) throws JMSException {
        for (int i = 0; i < this._subscriptionList.size(); ++i) {
            this._subscriptionList.get(i).send(session, msg, timeout);
        }
        this._protocol.send(this, msg, timeout);
    }
}

