/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.xmpp;

import com.caucho.jms.message.ObjectMessageImpl;
import com.caucho.jms.xmpp.Stanza;
import com.caucho.jms.xmpp.XmppProtocol;
import com.caucho.jms.xmpp.XmppPubSubLeaf;
import com.caucho.server.port.ServerRequest;
import com.caucho.server.port.TcpConnection;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import com.caucho.util.ThreadPool;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.stream.XMLStreamReaderImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmppRequest
implements ServerRequest,
Runnable {
    private static final L10N L = new L10N(XmppRequest.class);
    private static final Logger log = Logger.getLogger(XmppRequest.class.getName());
    private static final String STREAMS_NS = "http://etherx.jabber.org/streams";
    private XmppProtocol _protocol;
    private TcpConnection _conn;
    private ReadStream _is;
    private WriteStream _os;
    private volatile int _requestId;
    private String _id;
    private String _from;
    private String _clientTo;
    private String _streamFrom;
    private String _clientBind;
    private String _name;
    private XMLStreamReaderImpl _in;
    private boolean _isPresent;
    private boolean _isThread;
    private final ThreadPool _threadPool;
    private final BlockingQueue<Stanza> _outboundQueue = new ArrayBlockingQueue<Stanza>(1024);
    private State _state;
    private boolean _isFinest;

    XmppRequest(XmppProtocol protocol, TcpConnection conn) {
        this._protocol = protocol;
        this._conn = conn;
        this._threadPool = ThreadPool.getThreadPool();
    }

    int getRequestId() {
        return this._requestId;
    }

    public void init() {
    }

    public boolean isWaitForRead() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleRequest() throws IOException {
        boolean bl;
        ClassLoader oldLoader;
        Thread thread;
        block29: {
            boolean bl2;
            block28: {
                boolean bl3;
                block27: {
                    boolean bl4;
                    block26: {
                        thread = Thread.currentThread();
                        oldLoader = thread.getContextClassLoader();
                        try {
                            boolean bl5;
                            block25: {
                                try {
                                    int tag;
                                    thread.setContextClassLoader(this._protocol.getClassLoader());
                                    this._isFinest = log.isLoggable(Level.FINEST);
                                    if (this._state == null) {
                                        bl5 = this.handleInit();
                                        Object var7_8 = null;
                                        break block25;
                                    }
                                    while ((tag = this._in.next()) > 0) {
                                        if (this._isFinest) {
                                            this.debug(this._in);
                                        }
                                        if (tag == 2) {
                                            if ("stream".equals(this._in.getLocalName())) {
                                                if (log.isLoggable(Level.FINE)) {
                                                    log.fine(this + " end-stream");
                                                }
                                            } else {
                                                log.warning(this + " " + this._in.getLocalName());
                                            }
                                        }
                                        if (tag != 1) continue;
                                        boolean valid = false;
                                        if ("auth".equals(this._in.getLocalName())) {
                                            valid = this.handleAuth();
                                        } else if ("stream".equals(this._in.getLocalName())) {
                                            valid = this.handleStream();
                                        } else if ("iq".equals(this._in.getLocalName())) {
                                            valid = this.handleIq();
                                        } else if ("presence".equals(this._in.getLocalName())) {
                                            valid = this.handlePresence();
                                        } else {
                                            if (!"message".equals(this._in.getLocalName())) {
                                                bl4 = false;
                                                break block26;
                                            }
                                            valid = this.handleMessage();
                                        }
                                        if (!valid) {
                                            bl3 = false;
                                            break block27;
                                        }
                                        if (this._in.available() >= 1) continue;
                                        bl2 = true;
                                        break block28;
                                    }
                                    if (this._isFinest) {
                                        log.finest(this + " end of stream");
                                    }
                                    bl = false;
                                    break block29;
                                }
                                catch (XMLStreamException e) {
                                    e.printStackTrace();
                                    throw new IOExceptionWrapper((Throwable)e);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    throw e;
                                }
                                catch (RuntimeException e) {
                                    e.printStackTrace();
                                    throw e;
                                }
                            }
                            thread.setContextClassLoader(oldLoader);
                            return bl5;
                        }
                        catch (Throwable throwable) {
                            Object var7_13 = null;
                            thread.setContextClassLoader(oldLoader);
                            throw throwable;
                        }
                    }
                    Object var7_9 = null;
                    thread.setContextClassLoader(oldLoader);
                    return bl4;
                }
                Object var7_10 = null;
                thread.setContextClassLoader(oldLoader);
                return bl3;
            }
            Object var7_11 = null;
            thread.setContextClassLoader(oldLoader);
            return bl2;
        }
        Object var7_12 = null;
        thread.setContextClassLoader(oldLoader);
        return bl;
    }

    private boolean handleInit() throws IOException, XMLStreamException {
        String name;
        int tag;
        this._state = State.INIT;
        StringBuilder sb = new StringBuilder();
        Base64.encode((StringBuilder)sb, (long)RandomUtil.getRandomLong());
        while (sb.charAt(sb.length() - 1) == '=') {
            sb.setLength(sb.length() - 1);
        }
        this._id = sb.toString();
        this._is = this._conn.getReadStream();
        this._os = this._conn.getWriteStream();
        this._in = new XMLStreamReaderImpl(this._is);
        while ((tag = this._in.next()) > 0 && tag != 1) {
            if (!this._isFinest) continue;
            this.debug(this._in);
        }
        if (this._isFinest) {
            this.debug(this._in);
        }
        if (!"stream".equals(name = this._in.getLocalName())) {
            this._os.print("<error><invalid-xml/></error>");
            if (log.isLoggable(Level.FINE)) {
                log.fine(L.l("{0}: '{1}' is an unknown tag from {2}", (Object)this, (Object)name, (Object)this._conn.getRemoteAddress()));
            }
            return false;
        }
        if (!STREAMS_NS.equals(this._in.getNamespaceURI())) {
            this._os.print("<error><bad-namespace-prefix/></error>");
            if (log.isLoggable(Level.FINE)) {
                log.fine(L.l("{0}: xmlns='{1}' is an unknown namespace from {2}", (Object)this, (Object)name, (Object)this._conn.getRemoteAddress()));
            }
            return false;
        }
        if (!"1.0".equals(this._in.getAttributeValue(null, "version"))) {
            this._os.print("<error><unsupported-version/></error>");
            if (log.isLoggable(Level.FINE)) {
                log.fine(L.l("{0}: version='{1}' is an unknown version from {2}", (Object)this, (Object)this._in.getAttributeValue(null, "version"), (Object)this._conn.getRemoteAddress()));
            }
            return false;
        }
        String to = null;
        for (int i = this._in.getAttributeCount() - 1; i >= 0; --i) {
            String localName = this._in.getAttributeLocalName(i);
            String value = this._in.getAttributeValue(i);
            if (!"to".equals(localName)) continue;
            to = value;
        }
        String from = this._from;
        if (from == null) {
            from = to;
        }
        if (from == null) {
            from = this._conn.getLocalAddress().getHostAddress();
        }
        this._streamFrom = from;
        this._clientTo = from + "/" + this._id;
        this._os.print("<stream:stream xmlns='jabber:client'");
        this._os.print(" xmlns:stream='http://etherx.jabber.org/streams'");
        this._os.print(" id='" + this._id + "'");
        this._os.print(" from='" + from + "'");
        this._os.print(" version='1.0'>");
        this._os.print("<stream:features>");
        this._os.print("<mechanisms xmlns='urn:ietf:params:xml:ns:xmpp-sasl'>");
        this._os.print("<mechanism>PLAIN</mechanism>");
        this._os.print("</mechanisms>");
        this._os.print("<auth xmlns='http://jabber.org/features/iq-auth'></auth>");
        this._os.print("</stream:features>\n");
        this._os.flush();
        return true;
    }

    private boolean handleStream() throws IOException, XMLStreamException {
        String name = this._in.getLocalName();
        String to = null;
        for (int i = this._in.getAttributeCount() - 1; i >= 0; --i) {
            String localName = this._in.getAttributeLocalName(i);
            String value = this._in.getAttributeValue(i);
            if (!"to".equals(localName)) continue;
            to = value;
        }
        String from = this._from;
        if (from == null) {
            from = to;
        }
        if (from == null) {
            from = this._conn.getLocalAddress().getHostAddress();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " stream open(from=" + from + " id=" + this._id + ")");
        }
        this._os.print("<stream:stream xmlns='jabber:client'");
        this._os.print(" xmlns:stream='http://etherx.jabber.org/streams'");
        this._os.print(" id='" + this._id + "'");
        this._os.print(" from='" + from + "'");
        this._os.print(" version='1.0'>");
        this._os.print("<stream:features>");
        this._os.print("<bind xmlns='urn:ietf:params:xml:ns:xmpp-bind'/>");
        this._os.print("<session xmlns='urn:ietf:params:xml:ns:xmpp-session'/>");
        this._os.print("</stream:features>");
        this._os.flush();
        return true;
    }

    private boolean handleIq() throws IOException, XMLStreamException {
        String type = this._in.getAttributeValue(null, "type");
        String id = this._in.getAttributeValue(null, "id");
        String from = this._in.getAttributeValue(null, "from");
        String to = this._in.getAttributeValue(null, "to");
        int tag = this._in.nextTag();
        if (this._isFinest) {
            this.debug(this._in);
        }
        String localName = this._in.getLocalName();
        String uri = this._in.getNamespaceURI();
        if ("bind".equals(this._in.getLocalName())) {
            tag = this._in.nextTag();
            String resource = null;
            if ("resource".equals(this._in.getLocalName())) {
                this._in.next();
                resource = this._in.getText();
            }
            this.skipToEnd("iq");
            this._clientBind = "test@" + this._streamFrom + "/" + resource;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " bind-result(jid=" + this._clientBind + " id=" + id + " to=" + to + " from=" + from + ")");
            }
            this._os.print("<iq type='result' id='" + id + "' to='" + this._clientTo + "'>");
            this._os.print("<bind xmlns='urn:ietf:params:xml:ns:xmpp-bind'>");
            this._os.print("<jid>" + this._clientBind + "</jid>");
            this._os.print("</bind></iq>\n");
            this._os.flush();
            return true;
        }
        if ("session".equals(this._in.getLocalName())) {
            this.skipToEnd("iq");
            this._os.print("<iq type='result' id='" + id + "' from='" + this._streamFrom + "'/>");
            this._os.flush();
            return true;
        }
        if ("jabber:iq:roster".equals(this._in.getNamespaceURI()) && "query".equals(this._in.getLocalName())) {
            this.skipToEnd("iq");
            System.out.println("ROSTER: " + this._streamFrom);
            this._os.print("<iq type='result' id='" + id + "' from='" + this._streamFrom + "'>");
            this._os.print("<query xmlns='jabber:iq:roster'>");
            this._os.print("<item jid='jimmy@localhost' name='Test' subscription='to'>");
            this._os.print("<group>Buddies</group>");
            this._os.print("</item>");
            this._os.print("</query>");
            this._os.print("</iq>");
            this._os.flush();
            return true;
        }
        if ("query".equals(this._in.getLocalName()) && "http://jabber.org/protocol/disco#info".equals(uri)) {
            this.skipToEnd("iq");
            this._os.print("<iq type='result' id='" + id + "'");
            if (to != null) {
                this._os.print(" from='" + to + "'");
            }
            this._os.print(">");
            this._os.print("<query xmlns='http://jabber.org/protocol/disco#info'>");
            this._os.print("<identity category='pubsub' type='leaf' name='test'/>");
            this._os.print("<feature var='http://jabber.org/protocol/disco#info'/>");
            this._os.print("<feature var='jabber:iq:time'/>");
            this._os.print("<feature var='jabber:iq:search'/>");
            this._os.print("<feature var='http://jabber.org/protocol/muc'/>");
            this._os.print("<feature var='http://jabber.org/protocol/pubsub'/>");
            this._os.print("</query>");
            this._os.print("</iq>");
            this._os.flush();
            System.out.println("QUERY: " + type + " query:" + this._in.getLocalName() + " from:" + from + " to:" + to + " id:" + id);
            return true;
        }
        this.skipToEnd("iq");
        this._os.print("<iq type='error'>");
        this._os.print("<error/>");
        this._os.print("</iq>");
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " <" + this._in.getLocalName() + " xmlns=" + this._in.getNamespaceURI() + "> unknown iq");
        }
        return true;
    }

    private boolean handlePresence() throws IOException, XMLStreamException {
        int tag;
        String type = this._in.getAttributeValue(null, "type");
        String id = this._in.getAttributeValue(null, "id");
        String from = this._in.getAttributeValue(null, "from");
        String to = this._in.getAttributeValue(null, "to");
        while (!((tag = this._in.nextTag()) <= 0 || "presence".equals(this._in.getLocalName()) && tag == 2)) {
            if (this._isFinest) {
                this.debug(this._in);
            }
            if (tag != 1 || !"status".equals(this._in.getLocalName())) continue;
            tag = this._in.next();
            if (this._isFinest) {
                this.debug(this._in);
            }
            String status = this._in.getText();
            this.expectEnd("status");
        }
        if (this._isFinest) {
            this.debug(this._in);
        }
        this.expectEnd("presence", tag);
        if (!this._isPresent) {
            this._isPresent = true;
            this._protocol.addClient(this);
            this._os.print("<presence from='jimmy@localhost'>");
            this._os.print("<status>active</status>");
            this._os.print("</presence>");
        }
        return true;
    }

    private boolean handleMessage() throws IOException, XMLStreamException {
        int tag;
        String type = this._in.getAttributeValue(null, "type");
        String id = this._in.getAttributeValue(null, "id");
        String from = this._in.getAttributeValue(null, "from");
        String to = this._in.getAttributeValue(null, "to");
        XmppPubSubLeaf leaf = this._protocol.getNode(to);
        if (leaf == null) {
            log.fine(this + " message send to '" + to + "' unknown user");
            this.skipToEnd("message");
            return true;
        }
        String body = "";
        while (!((tag = this._in.next()) <= 0 || tag == 2 && "message".equals(this._in.getLocalName()))) {
            if (this._isFinest) {
                this.debug(this._in);
            }
            if (tag != 1 || !"body".equals(this._in.getLocalName()) || !"jabber:client".equals(this._in.getNamespaceURI())) continue;
            tag = this._in.next();
            if (this._isFinest) {
                this.debug(this._in);
            }
            body = this._in.getText();
            this.expectEnd("body");
        }
        this.expectEnd("message", tag);
        try {
            ObjectMessageImpl msg = new ObjectMessageImpl();
            msg.setJMSMessageID("ID:xmpp-test");
            msg.setObject((Serializable)((Object)body));
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " message to " + leaf);
            }
            leaf.send(null, msg, 0L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void skipToEnd(String tagName) throws IOException, XMLStreamException {
        int tag;
        XMLStreamReaderImpl in = this._in;
        if (in == null) {
            return;
        }
        while ((tag = in.next()) > 0) {
            if (this._isFinest) {
                this.debug(in);
            }
            if (tag == 1 || tag != 2 || !tagName.equals(in.getLocalName())) continue;
            return;
        }
    }

    private void expectEnd(String tagName) throws IOException, XMLStreamException {
        this.expectEnd(tagName, this._in.nextTag());
    }

    private void expectEnd(String tagName, int tag) throws IOException, XMLStreamException {
        if (tag != 2) {
            throw new IllegalStateException("expected </" + tagName + "> at <" + this._in.getLocalName() + ">");
        }
        if (!tagName.equals(this._in.getLocalName())) {
            throw new IllegalStateException("expected </" + tagName + "> at </" + this._in.getLocalName() + ">");
        }
    }

    private boolean handleAuth() throws IOException, XMLStreamException {
        String mechanism = this._in.getAttributeValue(null, "mechanism");
        if ("PLAIN".equals(mechanism)) {
            return this.handleAuthPlain();
        }
        throw new IllegalStateException("Unknown mechanism: " + mechanism);
    }

    private boolean handleAuthPlain() throws IOException, XMLStreamException {
        String decoded;
        int p;
        int tag;
        String value = null;
        while ((tag = this._in.next()) > 0 && tag != 1 && tag != 2) {
            if (this._isFinest) {
                this.debug(this._in);
            }
            if (tag != 4) continue;
            char[] buffer = this._in.getTextCharacters();
            int start = this._in.getTextStart();
            int len = this._in.getTextLength();
            value = new String(this._in.getTextCharacters(), start, len);
        }
        if (value == null) {
            return false;
        }
        if (this._isFinest) {
            this.debug(this._in);
        }
        if ((p = (decoded = Base64.decode(value)).indexOf(0, 1)) < 0) {
            return false;
        }
        String name = decoded.substring(1, p);
        String password = decoded.substring(p + 1);
        boolean isAuth = true;
        if (isAuth) {
            this._name = name;
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " auth-plain success for " + name);
            }
            this._os.print("<success xmlns='urn:ietf:params:xml:ns:xmpp-sasl'></success>");
            this._os.flush();
            return true;
        }
        return false;
    }

    private void debug(XMLStreamReader in) throws IOException, XMLStreamException {
        if (1 == in.getEventType()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<").append(in.getLocalName());
            if (in.getNamespaceURI() != null) {
                sb.append("{").append(in.getNamespaceURI()).append("}");
            }
            for (int i = 0; i < in.getAttributeCount(); ++i) {
                sb.append(" ");
                sb.append(in.getAttributeLocalName(i));
                sb.append("='");
                sb.append(in.getAttributeValue(i));
                sb.append("'");
            }
            sb.append(">");
            log.finest(this + " " + sb);
        } else if (2 == in.getEventType()) {
            log.finest(this + " </" + in.getLocalName() + ">");
        } else if (4 == in.getEventType()) {
            String text = in.getText().trim();
            if (!"".equals(text)) {
                log.finest(this + " text='" + text + "'");
            }
        } else {
            log.finest(this + " tag=" + in.getEventType());
        }
    }

    public boolean handleResume() throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protocolCloseEvent() {
        this._protocol.removeClient(this);
        ++this._requestId;
        this._state = null;
        this._isPresent = false;
        XmppRequest xmppRequest = this;
        synchronized (xmppRequest) {
            this._outboundQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(int requestId, Stanza stanza) {
        XmppRequest xmppRequest = this;
        synchronized (xmppRequest) {
            if (requestId != this._requestId || !this._isPresent) {
                return;
            }
            if (this._outboundQueue.offer(stanza) && !this._isThread) {
                this._isThread = true;
                this._threadPool.schedule((Runnable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int id = this._requestId;
        while (id == this._requestId) {
            Stanza stanza = null;
            XmppRequest xmppRequest = this;
            synchronized (xmppRequest) {
                stanza = (Stanza)this._outboundQueue.poll();
                if (stanza == null) {
                    this._isThread = false;
                    return;
                }
            }
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finest(this + " send from=localhost/test to=" + this._clientBind + " " + stanza);
                }
                stanza.print(this._os, "localhost/test", this._clientBind);
                this._os.flush();
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    public String toString() {
        if (this._conn != null) {
            return this.getClass().getSimpleName() + "[" + this._conn.getId() + "]";
        }
        return this.getClass().getSimpleName() + "[]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INIT;

    }
}

