/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.xmpp;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.queue.AbstractQueue;
import com.caucho.jms.queue.AbstractTopic;
import com.caucho.jms.xmpp.XmppProtocol;
import com.caucho.jms.xmpp.XmppPubSubLeaf;
import com.caucho.util.L10N;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.jms.JMSException;
import javax.webbeans.ComponentFactory;

public class XmppTopic
extends AbstractTopic {
    private static final L10N L = new L10N(XmppTopic.class);
    private static final Logger log = Logger.getLogger(XmppTopic.class.getName());
    private XmppPubSubLeaf _xmppNode;
    private int _id;

    public String getUrl() {
        return "xmpp:name=" + this.getName();
    }

    @PostConstruct
    public void init() {
        super.init();
        WebBeansContainer container = WebBeansContainer.create();
        ComponentFactory<XmppProtocol> comp = container.resolveByType(XmppProtocol.class, new Annotation[0]);
        if (comp == null) {
            throw new IllegalStateException(L.l("Need xmpp protocol"));
        }
        XmppProtocol xmpp = (XmppProtocol)comp.get();
        if (xmpp == null) {
            throw new IllegalStateException(L.l("Need xmpp protocol"));
        }
        this._xmppNode = xmpp.createNode(this.getName());
    }

    public AbstractQueue createSubscriber(JmsSession session, String name, boolean noLocal) {
        return this._xmppNode.createSubscriber(session, name, noLocal);
    }

    public void closeSubscriber(AbstractQueue queue) {
        this._xmppNode.closeSubscriber(queue);
    }

    public void send(JmsSession session, MessageImpl msg, long timeout) throws JMSException {
        this._xmppNode.send(session, msg, timeout);
    }
}

