/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.EnvironmentMBeanServer;
import com.caucho.jmx.MBeanServerDelegateImpl;
import com.caucho.log.Log;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;

public class EnvironmentMBeanServerBuilder {
    private static final Logger log = Log.open(EnvironmentMBeanServerBuilder.class);
    private static MBeanServer _globalServer;
    private MBeanServer _mbeanServer;
    private boolean _isInit;

    public MBeanServerDelegate newMBeanServerDelegate() {
        return new MBeanServerDelegateImpl("Resin-JMX");
    }

    public MBeanServer newMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        if (!this._isInit) {
            this._isInit = true;
            try {
                Class<?> cl = Class.forName("java.lang.management.ManagementFactory");
                Method method = cl.getMethod("getPlatformMBeanServer", new Class[0]);
                this._mbeanServer = (MBeanServer)method.invoke(null, new Object[0]);
                return this._mbeanServer;
            }
            catch (ClassNotFoundException e) {
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (this._mbeanServer == null && defaultDomain == null) {
            defaultDomain = "resin";
        }
        return this._mbeanServer;
    }

    public static MBeanServer getGlobal(String defaultDomain) {
        if (_globalServer == null) {
            if (defaultDomain == null) {
                defaultDomain = "resin";
            }
            MBeanServerDelegateImpl delegate = new MBeanServerDelegateImpl("Resin-JMX");
            _globalServer = new EnvironmentMBeanServer(defaultDomain, delegate);
        }
        return _globalServer;
    }
}

