/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.application;

import com.caucho.jsf.context.JspResponseWrapper;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.jstl.core.Config;

public class JspViewHandler
extends ViewHandler {
    private static final L10N L = new L10N(JspViewHandler.class);

    public Locale calculateLocale(FacesContext context) {
        Locale locale;
        if (context == null) {
            throw new NullPointerException();
        }
        ExternalContext extContext = context.getExternalContext();
        ArrayList supportedLocales = new ArrayList();
        Iterator iter = context.getApplication().getSupportedLocales();
        while (iter != null && iter.hasNext()) {
            supportedLocales.add(iter.next());
        }
        iter = extContext.getRequestLocales();
        while (iter.hasNext()) {
            locale = (Locale)iter.next();
            for (int i = 0; i < supportedLocales.size(); ++i) {
                Locale supLocale = (Locale)supportedLocales.get(i);
                if (supLocale.equals(locale)) {
                    return supLocale;
                }
                if (!"".equals(supLocale.getCountry()) || !locale.getLanguage().equals(supLocale.getLanguage())) continue;
                return supLocale;
            }
        }
        locale = context.getApplication().getDefaultLocale();
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    public String calculateCharacterEncoding(FacesContext context) {
        Map sessionMap;
        Object value;
        int p;
        if (context == null) {
            throw new NullPointerException();
        }
        ExternalContext extContext = context.getExternalContext();
        HttpServletRequest req = (HttpServletRequest)extContext.getRequest();
        String contentType = req.getHeader("Content-Type");
        if (contentType != null && (p = contentType.indexOf("charset=")) > 0) {
            int q = contentType.indexOf(59, p + 9);
            String charset = q > 0 ? contentType.substring(p + 8, q).trim() : contentType.substring(p + 8).trim();
            return charset;
        }
        if (extContext.getSession(false) != null && (value = (sessionMap = extContext.getSessionMap()).get("javax.faces.request.charset")) != null) {
            return value.toString();
        }
        return "utf-8";
    }

    public String calculateRenderKitId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        ExternalContext extContext = context.getExternalContext();
        Map requestMap = extContext.getRequestMap();
        String id = (String)requestMap.get("javax.faces.RenderKitId");
        if (id != null) {
            return id;
        }
        Application app = context.getApplication();
        id = app.getDefaultRenderKitId();
        if (id != null) {
            return id;
        }
        return "HTML_BASIC";
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        if (context == null) {
            throw new NullPointerException();
        }
        viewId = viewId != null ? JspViewHandler.convertViewId(context, viewId) : JspViewHandler.createViewId(context);
        ExternalContext extContext = context.getExternalContext();
        String servletPath = extContext.getRequestServletPath();
        if (viewId == null || viewId.equals(servletPath) || servletPath == null && viewId.equals(extContext.getRequestPathInfo())) {
            try {
                extContext.redirect(extContext.getRequestContextPath());
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
            context.renderResponse();
            context.responseComplete();
            return null;
        }
        UIViewRoot viewRoot = new UIViewRoot();
        viewRoot.setViewId(viewId);
        UIViewRoot oldView = context.getViewRoot();
        String renderKitId = null;
        if (oldView != null) {
            renderKitId = oldView.getRenderKitId();
        }
        if (renderKitId == null) {
            renderKitId = this.calculateRenderKitId(context);
        }
        viewRoot.setRenderKitId(renderKitId);
        Locale locale = null;
        if (oldView != null) {
            locale = oldView.getLocale();
        }
        if (locale == null) {
            locale = this.calculateLocale(context);
        }
        viewRoot.setLocale(locale);
        return viewRoot;
    }

    public static String createViewId(FacesContext context) {
        int dot;
        ExternalContext extContext = context.getExternalContext();
        Map requestMap = extContext.getRequestMap();
        boolean isInclude = requestMap.containsKey("javax.servlet.include.request_uri");
        String pathInfo = isInclude ? (String)requestMap.get("javax.servlet.include.path_info") : extContext.getRequestPathInfo();
        if (pathInfo != null) {
            return pathInfo;
        }
        String servletPath = extContext.getRequestServletPath();
        if (servletPath != null && (dot = servletPath.lastIndexOf(46)) > 0 && servletPath.lastIndexOf(47) < dot) {
            String suffix = extContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            if (suffix == null) {
                suffix = ".jsp";
            }
            return servletPath.substring(0, dot) + suffix;
        }
        throw new FacesException(L.l("no view-id found"));
    }

    static String convertViewId(FacesContext context, String viewId) {
        ExternalContext extContext = context.getExternalContext();
        Map requestMap = extContext.getRequestMap();
        boolean isInclude = requestMap.containsKey("javax.servlet.include.request_uri");
        String pathInfo = isInclude ? (String)requestMap.get("javax.servlet.include.path_info") : extContext.getRequestPathInfo();
        if (pathInfo != null) {
            return viewId;
        }
        int dot = viewId.lastIndexOf(46);
        if (dot > 0 && viewId.lastIndexOf(47) < dot) {
            String suffix = extContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            if (suffix == null) {
                suffix = ".jsp";
            }
            return viewId.substring(0, dot) + suffix;
        }
        return viewId;
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (context == null || viewId == null) {
            throw new NullPointerException();
        }
        if (!viewId.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        ExternalContext extContext = context.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            int lastDot = viewId.lastIndexOf(46);
            return contextPath + (lastDot == -1 ? viewId : viewId.substring(0, lastDot) + servletPath.substring(servletPath.lastIndexOf(46)));
        }
        return contextPath + servletPath + viewId;
    }

    public String getResourceURL(FacesContext context, String path) {
        if (path.startsWith("/")) {
            ExternalContext extContext = context.getExternalContext();
            HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
            return request.getContextPath() + path;
        }
        return path;
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (!viewToRender.isRendered()) {
            return;
        }
        String viewId = viewToRender.getViewId();
        ExternalContext extContext = context.getExternalContext();
        HttpServletResponse response = (HttpServletResponse)extContext.getResponse();
        HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
        Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)viewToRender);
        response.setContentType("text/html");
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        String renderKitId = viewToRender.getRenderKitId();
        if (renderKitId == null) {
            renderKitId = "HTML_BASIC";
        }
        RenderKit renderKit = renderKitFactory.getRenderKit(context, renderKitId);
        String encoding = request.getCharacterEncoding();
        ResponseWriter oldOut = context.getResponseWriter();
        ResponseWriter out = renderKit.createResponseWriter((Writer)response.getWriter(), null, encoding);
        JspResponseWrapper resWrapper = new JspResponseWrapper();
        resWrapper.init(response);
        extContext.setResponse((Object)resWrapper);
        extContext.dispatch(viewId);
        String tail = resWrapper.complete();
        extContext.setResponse((Object)response);
        context.setResponseWriter(out);
        out.startDocument();
        viewToRender.encodeAll(context);
        if (tail != null) {
            out.write(tail);
        }
        out.endDocument();
        context.setResponseWriter(oldOut);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) throws FacesException {
        if (context == null) {
            throw new NullPointerException();
        }
        viewId = viewId != null ? JspViewHandler.convertViewId(context, viewId) : JspViewHandler.createViewId(context);
        String renderKitId = this.calculateRenderKitId(context);
        StateManager stateManager = context.getApplication().getStateManager();
        return stateManager.restoreView(context, viewId, renderKitId);
    }

    public void writeState(FacesContext context) throws IOException {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot != null) {
            StateManager stateManager = context.getApplication().getStateManager();
            Object state = stateManager.saveView(context);
            stateManager.writeState(context, state);
        }
    }

    public String toString() {
        return "JspViewHandler[]";
    }
}

