/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.application;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIColumn;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIForm;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIInput;
import javax.faces.component.UIMessage;
import javax.faces.component.UIMessages;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.component.UIPanel;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlColumn;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.component.html.HtmlForm;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.component.html.HtmlInputSecret;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.component.html.HtmlMessage;
import javax.faces.component.html.HtmlMessages;
import javax.faces.component.html.HtmlOutputFormat;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.component.html.HtmlSelectManyListbox;
import javax.faces.component.html.HtmlSelectManyMenu;
import javax.faces.component.html.HtmlSelectOneListbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionStateManager
extends StateManager {
    private static final L10N L = new L10N(SessionStateManager.class);
    private static final Logger log = Logger.getLogger(SessionStateManager.class.getName());
    private static final IntMap _typeMap = new IntMap();
    private static final ArrayList<Class> _typeList = new ArrayList();

    public Object saveView(FacesContext context) {
        UIViewRoot root = context.getViewRoot();
        if (root == null || root.isTransient()) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Hessian2Output out = new Hessian2Output((OutputStream)bos);
            this.serialize((AbstractHessianOutput)out, context, (UIComponent)root, new HashSet<String>());
            out.close();
            byte[] state = bos.toByteArray();
            if (log.isLoggable(Level.FINE)) {
                log.fine("JSF[" + root.getViewId() + "] serialize (" + state.length + " bytes)");
                if (log.isLoggable(Level.FINER)) {
                    this.debugState(state);
                }
            }
            if (!this.isSavingStateInClient(context)) {
                Map sessionMap = context.getExternalContext().getSessionMap();
                HashMap<String, byte[]> viewMap = (HashMap<String, byte[]>)sessionMap.get("caucho.jsf.view");
                if (viewMap == null) {
                    viewMap = new HashMap<String, byte[]>();
                }
                viewMap.put(root.getViewId(), state);
                sessionMap.put("caucho.jsf.view", viewMap);
                return "!";
            }
            return state;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public StateManager.SerializedView saveSerializedView(FacesContext context) {
        return new StateManager.SerializedView((StateManager)this, this.saveView(context), null);
    }

    @Deprecated
    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        Object[] stateArray = new Object[]{state.getStructure(), state.getState()};
        this.writeState(context, stateArray);
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        ResponseStateManager rsm = context.getRenderKit().getResponseStateManager();
        if (!(state instanceof Object[])) {
            rsm.writeState(context, (Object)new Object[]{state, null});
        } else {
            rsm.writeState(context, state);
        }
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        Map viewMap;
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null) {
            RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            renderKit = renderKitFactory.getRenderKit(context, renderKitId);
        }
        ResponseStateManager rsm = renderKit.getResponseStateManager();
        Object state = rsm.getState(context, viewId);
        if (!this.isSavingStateInClient(context) && "!".equals(((Object[])state)[0]) && (viewMap = (Map)context.getExternalContext().getSessionMap().get("caucho.jsf.view")) != null) {
            state = viewMap.get(viewId);
        }
        if (state == null) {
            return null;
        }
        if (state instanceof byte[]) {
            return this.restoreView(context, (byte[])state);
        }
        if (state instanceof Object[]) {
            return this.restoreView(context, (byte[])((Object[])state)[0]);
        }
        if (state instanceof StateManager.SerializedView) {
            StateManager.SerializedView serView = (StateManager.SerializedView)state;
            return this.restoreView(context, (byte[])serView.getStructure());
        }
        throw new IllegalStateException(L.l("unexpected saved state: '{0}'", state));
    }

    private void serialize(AbstractHessianOutput out, FacesContext context, UIComponent comp, HashSet<String> idMap) throws IOException {
        int fullChildCount;
        if (comp.isTransient()) {
            return;
        }
        if (idMap.contains(comp.getId())) {
            throw new IllegalStateException(L.l("'{0}' is a duplicate component during serialization.", (Object)comp.getId()));
        }
        if (comp.getId() != null) {
            idMap.add(comp.getId());
        }
        if (comp instanceof NamingContainer) {
            idMap = new HashSet(8);
        }
        int typeId = _typeMap.get(comp.getClass());
        out.writeInt(typeId);
        if (typeId <= 0) {
            out.writeString(comp.getClass().getName());
        }
        if ((fullChildCount = comp.getChildCount()) > 0) {
            UIComponent child;
            int i;
            int childCount = 0;
            List children = comp.getChildren();
            for (i = 0; i < fullChildCount; ++i) {
                child = (UIComponent)children.get(i);
                if (child.isTransient()) continue;
                ++childCount;
            }
            out.writeInt(childCount);
            for (i = 0; i < fullChildCount; ++i) {
                child = (UIComponent)children.get(i);
                this.serialize(out, context, child, idMap);
            }
        } else {
            out.writeInt(0);
        }
        int facetCount = comp.getFacetCount();
        out.writeInt(facetCount);
        if (facetCount > 0) {
            for (Map.Entry entry : comp.getFacets().entrySet()) {
                out.writeString((String)entry.getKey());
                this.serialize(out, context, (UIComponent)entry.getValue(), idMap);
            }
        }
        out.writeObject(comp.saveState(context));
    }

    private UIViewRoot restoreView(FacesContext context, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            Hessian2Input in = new Hessian2Input((InputStream)bis);
            return (UIViewRoot)this.deserialize((AbstractHessianInput)in, context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private UIComponent deserialize(AbstractHessianInput in, FacesContext context) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> type;
        int typeId = in.readInt();
        if (typeId > 0) {
            type = _typeList.get(typeId);
        } else {
            String typeName = in.readString();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            type = Class.forName(typeName, false, loader);
        }
        UIComponent comp = (UIComponent)type.newInstance();
        int childCount = in.readInt();
        for (int i = 0; i < childCount; ++i) {
            comp.getChildren().add(this.deserialize(in, context));
        }
        int facetCount = in.readInt();
        for (int i = 0; i < facetCount; ++i) {
            String key = in.readString();
            comp.getFacets().put(key, this.deserialize(in, context));
        }
        comp.restoreState(context, in.readObject());
        return comp;
    }

    public String toString() {
        return "SessionStateManager[]";
    }

    private static void addType(Class type) {
        if (_typeMap.get((Object)type) > 0) {
            return;
        }
        _typeMap.put((Object)type, _typeList.size());
        _typeList.add(type);
    }

    private void debugState(byte[] state) {
        for (int i = 0; i < state.length; ++i) {
            byte ch;
            if (i != 0 && i % 40 == 0) {
                System.out.println();
            }
            if (97 <= (ch = state[i]) && ch <= 122 || 65 <= ch && ch <= 90 || 48 <= ch && ch <= 57 || ch == 32 || ch == 91 || ch == 46 || ch == 93 || ch == 47 || ch == 92 || ch == 45 || ch == 95 || ch == 123 || ch == 125 || ch == 35 || ch == 36 || ch == 58) {
                System.out.print((char)ch);
                continue;
            }
            System.out.print("x" + Integer.toHexString(ch / 16 & 0xF) + Integer.toHexString(ch & 0xF));
        }
        System.out.println();
    }

    static {
        _typeList.add(null);
        SessionStateManager.addType(UIColumn.class);
        SessionStateManager.addType(UICommand.class);
        SessionStateManager.addType(UIData.class);
        SessionStateManager.addType(UIForm.class);
        SessionStateManager.addType(UIGraphic.class);
        SessionStateManager.addType(UIInput.class);
        SessionStateManager.addType(UIMessage.class);
        SessionStateManager.addType(UIMessages.class);
        SessionStateManager.addType(UINamingContainer.class);
        SessionStateManager.addType(UIOutput.class);
        SessionStateManager.addType(UIPanel.class);
        SessionStateManager.addType(UIParameter.class);
        SessionStateManager.addType(UISelectBoolean.class);
        SessionStateManager.addType(UISelectItem.class);
        SessionStateManager.addType(UISelectItems.class);
        SessionStateManager.addType(UISelectMany.class);
        SessionStateManager.addType(UISelectOne.class);
        SessionStateManager.addType(UIViewRoot.class);
        SessionStateManager.addType(HtmlColumn.class);
        SessionStateManager.addType(HtmlCommandButton.class);
        SessionStateManager.addType(HtmlCommandLink.class);
        SessionStateManager.addType(HtmlDataTable.class);
        SessionStateManager.addType(HtmlForm.class);
        SessionStateManager.addType(HtmlGraphicImage.class);
        SessionStateManager.addType(HtmlInputHidden.class);
        SessionStateManager.addType(HtmlInputSecret.class);
        SessionStateManager.addType(HtmlInputText.class);
        SessionStateManager.addType(HtmlInputTextarea.class);
        SessionStateManager.addType(HtmlMessage.class);
        SessionStateManager.addType(HtmlMessages.class);
        SessionStateManager.addType(HtmlOutputFormat.class);
        SessionStateManager.addType(HtmlOutputLabel.class);
        SessionStateManager.addType(HtmlOutputLink.class);
        SessionStateManager.addType(HtmlOutputText.class);
        SessionStateManager.addType(HtmlPanelGrid.class);
        SessionStateManager.addType(HtmlPanelGroup.class);
        SessionStateManager.addType(HtmlSelectBooleanCheckbox.class);
        SessionStateManager.addType(HtmlSelectManyCheckbox.class);
        SessionStateManager.addType(HtmlSelectManyListbox.class);
        SessionStateManager.addType(HtmlSelectManyMenu.class);
        SessionStateManager.addType(HtmlSelectOneListbox.class);
        SessionStateManager.addType(HtmlSelectOneMenu.class);
        SessionStateManager.addType(HtmlSelectOneRadio.class);
    }
}

