/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.cfg;

import com.caucho.config.ConfigException;
import com.caucho.jsf.cfg.AbstractValue;
import com.caucho.jsf.cfg.BeanProgram;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPropertyBeanProgram
extends BeanProgram {
    private static final Logger log = Logger.getLogger(ListPropertyBeanProgram.class.getName());
    private static final L10N L = new L10N(ListPropertyBeanProgram.class);
    private Method _getter;
    private Method _setter;
    private List<AbstractValue> _values;
    private String _propertyName;

    public ListPropertyBeanProgram(Method getter, Method setter, List<AbstractValue> values, String propertyName) {
        this._getter = getter;
        this._setter = setter;
        this._values = values;
        this._propertyName = propertyName;
    }

    @Override
    public void configure(FacesContext context, Object bean) throws ConfigException {
        try {
            ArrayList<Object> list = null;
            boolean listNew = false;
            if (this._getter != null) {
                list = (ArrayList<Object>)this._getter.invoke(bean, new Object[0]);
            }
            if (list == null) {
                if (this._setter == null) {
                    if (log.isLoggable(Level.CONFIG)) {
                        log.log(Level.CONFIG, L.l("Setter for {0} not found in type {1}", (Object)this._propertyName, (Object)bean.getClass().getName()));
                    }
                    return;
                }
                list = new ArrayList<Object>();
                listNew = true;
            }
            for (int i = 0; i < this._values.size(); ++i) {
                AbstractValue value = this._values.get(i);
                list.add(value.getValue(context));
            }
            if (listNew) {
                this._setter.invoke(bean, list);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }
}

