/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.cfg;

import com.caucho.config.ConfigException;
import com.caucho.jsf.cfg.AbstractValue;
import com.caucho.jsf.cfg.BeanProgram;
import com.caucho.jsf.cfg.ListBeanProgram;
import com.caucho.jsf.cfg.ListEntries;
import com.caucho.jsf.cfg.ManagedProperty;
import com.caucho.jsf.cfg.MapBeanProgram;
import com.caucho.jsf.cfg.MappedEntries;
import com.caucho.jsf.el.ManagedBeanELResolver;
import com.caucho.util.L10N;
import java.util.ArrayList;
import javax.el.ELContext;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.xml.bind.annotation.XmlElement;

public class ManagedBeanConfig {
    private static final L10N L = new L10N(ManagedBeanConfig.class);
    private String _configLocation;
    private String _id;
    private String _name;
    private String _typeName;
    private Class _type;
    private ArrayList<BeanProgram> _program = new ArrayList();
    private Scope _scope = Scope.REQUEST;

    public void setId(String id) {
    }

    public void setDescription(String description) {
    }

    public void setManagedBeanName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setConfigLocation(String location) {
        this._configLocation = location;
    }

    @XmlElement(name="managed-bean-class")
    public void setManagedBeanClass(String cl) {
        this._typeName = cl;
    }

    public String getManagedBeanClass() {
        return this._typeName;
    }

    public Class getType() {
        if (this._type == null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                this._type = Class.forName(this._typeName, false, loader);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
        return this._type;
    }

    @XmlElement(name="managed-bean-scope")
    public void setManagedBeanScope(String scope) {
        if ("request".equals(scope)) {
            this._scope = Scope.REQUEST;
        } else if ("session".equals(scope)) {
            this._scope = Scope.SESSION;
        } else if ("application".equals(scope)) {
            this._scope = Scope.APPLICATION;
        } else if ("none".equals(scope)) {
            this._scope = Scope.NONE;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown managed-bean-scope.  Expected values are request, session, application, or none.", (Object)scope));
        }
    }

    public String getManagedBeanScope() {
        return this._scope.toString();
    }

    @XmlElement(name="managed-property")
    public void setManagedProperty(ManagedProperty property) {
        property.addProgram(this._program, this.getType());
    }

    public ManagedProperty getManagedProperty() {
        throw new UnsupportedOperationException();
    }

    public void setMapEntries(MappedEntries map) {
        ArrayList<AbstractValue> keyList = map.getKeyList();
        ArrayList<AbstractValue> valueList = map.getValueList();
        for (int i = 0; i < keyList.size(); ++i) {
            this._program.add(new MapBeanProgram(keyList.get(i), valueList.get(i)));
        }
    }

    public void setListEntries(ListEntries list) {
        for (AbstractValue value : list.getListValues()) {
            this._program.add(new ListBeanProgram(value));
        }
    }

    public Object create(FacesContext context, ManagedBeanELResolver.Scope createScope) throws FacesException {
        try {
            ELContext elContext = context.getELContext();
            boolean isPropertyResolved = elContext.isPropertyResolved();
            Object value = this.getType().newInstance();
            if (createScope.getScope() < this._scope.ordinal()) {
                throw new FacesException(L.l("Scope '{0}' is long for enclosing bean.", (Object)this._scope));
            }
            if (this._scope.ordinal() < createScope.getScope()) {
                createScope.setScope(this._scope.ordinal());
            }
            for (int i = 0; i < this._program.size(); ++i) {
                this._program.get(i).configure(context, value);
            }
            ExternalContext extContext = context.getExternalContext();
            switch (this._scope) {
                case APPLICATION: {
                    extContext.getApplicationMap().put(this._name, value);
                    break;
                }
                case SESSION: {
                    extContext.getSessionMap().put(this._name, value);
                    break;
                }
                case REQUEST: {
                    extContext.getRequestMap().put(this._name, value);
                }
            }
            elContext.setPropertyResolved(isPropertyResolved);
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Scope {
        NONE,
        APPLICATION,
        SESSION,
        REQUEST;

    }
}

