/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.cfg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationRule
implements Comparable<NavigationRule> {
    private static final Logger log = Logger.getLogger(NavigationRule.class.getName());
    private String _id;
    private String _fromViewId;
    private Pattern _fromViewIdPattern;
    private int _cost;
    private ArrayList<NavigationCase> _caseList = new ArrayList();

    public void setId(String id) {
        this._id = id;
    }

    public void setDescription(String description) {
    }

    public void setDisplayName(String displayName) {
    }

    public int getCost() {
        return this._cost;
    }

    @Override
    public int compareTo(NavigationRule rule) {
        return rule.getCost() - this._cost;
    }

    public void setFromViewId(String viewId) {
        this._fromViewId = viewId;
        this._cost = viewId.length();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < viewId.length(); ++i) {
            char ch = viewId.charAt(i);
            switch (ch) {
                case '*': {
                    if (i < this._cost) {
                        this._cost = i;
                    }
                    sb.append(".*");
                    continue block4;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    sb.append("\\");
                    sb.append(ch);
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        this._fromViewIdPattern = Pattern.compile(sb.toString());
    }

    public boolean isMatch(String url) {
        return this._fromViewIdPattern == null || this._fromViewIdPattern.matcher(url).matches();
    }

    public void addNavigationCase(NavigationCase navCase) {
        this._caseList.add(navCase);
    }

    public boolean handleNavigation(FacesContext context, String action, String outcome) {
        NavigationCase navCase = this.findCase(action, outcome);
        if (navCase != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Jsf[" + context.getViewRoot().getViewId() + "] navigation action:" + action + " outcome:" + outcome + " matches " + navCase);
            }
            navCase.handleNavigation(context);
            return true;
        }
        return false;
    }

    private NavigationCase findCase(String action, String outcome) {
        NavigationCase bestCase = null;
        int bestCost = -1;
        for (int i = 0; i < this._caseList.size(); ++i) {
            NavigationCase navCase = this._caseList.get(i);
            int cost = 0;
            if (navCase.getFromAction() != null) {
                if (action == null || !action.equals(navCase.getFromAction())) continue;
                cost |= 1;
            }
            if (navCase.getFromOutcome() != null) {
                if (outcome == null || !outcome.equals(navCase.getFromOutcome())) continue;
                cost |= 2;
            }
            if (cost == 3) {
                return navCase;
            }
            if (bestCost >= cost) continue;
            bestCost = cost;
            bestCase = navCase;
        }
        return bestCase;
    }

    public String toString() {
        return "NavigationRule[" + this._fromViewIdPattern + "]";
    }

    public static class Redirect {
        public void setId(String id) {
        }
    }

    public static class NavigationCase {
        private String _fromAction;
        private String _fromOutcome;
        private String _toViewId;
        private boolean _isRedirect;

        public void setId(String id) {
        }

        public void setDescription(String description) {
        }

        public void setDisplayName(String displayName) {
        }

        public void setFromAction(String expr) {
            this._fromAction = expr;
        }

        public String getFromAction() {
            return this._fromAction;
        }

        public void setFromOutcome(String expr) {
            this._fromOutcome = expr;
        }

        public String getFromOutcome() {
            return this._fromOutcome;
        }

        public void setToViewId(String viewId) {
            this._toViewId = viewId;
        }

        public void setRedirect(Redirect redirect) {
            this._isRedirect = true;
        }

        public void handleNavigation(FacesContext context) {
            if (this._isRedirect) {
                try {
                    ExternalContext extContext = context.getExternalContext();
                    ViewHandler viewHandler = context.getApplication().getViewHandler();
                    String actionUrl = viewHandler.getActionURL(context, this._toViewId);
                    extContext.redirect(extContext.encodeActionURL(actionUrl));
                    context.responseComplete();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                UIViewRoot oldView = context.getViewRoot();
                ViewHandler view = context.getApplication().getViewHandler();
                UIViewRoot viewRoot = view.createView(context, this._toViewId);
                if (oldView != null) {
                    viewRoot.setLocale(oldView.getLocale());
                }
                context.setViewRoot(viewRoot);
            }
        }

        public String toString() {
            if (this._isRedirect) {
                return "NavCase[redirect," + this._toViewId + "]";
            }
            return "NavCase[" + this._toViewId + "]";
        }
    }
}

