/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.context;

import com.caucho.jsp.BodyResponseStream;
import com.caucho.server.connection.AbstractResponseStream;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.connection.ResponseWrapper;
import com.caucho.server.connection.ResponseWriter;
import com.caucho.server.connection.ServletOutputStreamImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.FlushBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class JspResponseWrapper
extends ResponseWrapper
implements CauchoResponse {
    private static final Logger log = Logger.getLogger(JspResponseWrapper.class.getName());
    private static final L10N L = new L10N(JspResponseWrapper.class);
    private boolean _hasError;
    private BodyResponseStream _bodyStream;
    private AbstractResponseStream _stream;
    private HttpServletResponse _response;
    private TempStream _tempStream = new TempStream();
    private WriteStream _out;
    private FlushBuffer _flushBuffer;
    private ResponseWriter _writer = new ResponseWriter();
    private ServletOutputStreamImpl _os = new ServletOutputStreamImpl();

    public void init(HttpServletResponse response) {
        this._bodyStream = new BodyResponseStream();
        this._stream = this._bodyStream;
        this._out = new WriteStream((StreamImpl)this._tempStream);
        this._bodyStream.setWriter(this._out.getPrintWriter());
        this.setResponse(response);
        this._response = response;
        this._os.init((OutputStream)((Object)this._stream));
        this._writer.init(this._stream);
        this._hasError = false;
    }

    public void setResponseStream(AbstractResponseStream stream) {
        try {
            this._stream.flushBuffer();
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        this._stream = stream;
        this._os.init((OutputStream)((Object)stream));
        this._writer.init(stream);
    }

    public AbstractResponseStream getResponseStream() {
        return this._stream;
    }

    public boolean isCauchoResponseStream() {
        return true;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this._os;
    }

    public PrintWriter getWriter() throws IOException {
        return this._writer;
    }

    protected OutputStream getStream() throws IOException {
        return this._response.getOutputStream();
    }

    public void setFlushBuffer(FlushBuffer flushBuffer) {
        this._flushBuffer = flushBuffer;
    }

    public FlushBuffer getFlushBuffer() {
        return this._flushBuffer;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
        if (this._stream != null) {
            this._stream.clearBuffer();
        }
    }

    public void clearBuffer() {
        this.resetBuffer();
    }

    public void setLocale(Locale locale) {
        this._response.setLocale(locale);
        try {
            this._stream.setLocale(this._response.getLocale());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getHeader(String key) {
        return null;
    }

    public boolean disableHeaders(boolean disable) {
        return false;
    }

    public int getRemaining() {
        return this._stream.getRemaining();
    }

    public void setForbidForward(boolean forbid) {
    }

    public boolean getForbidForward() {
        return false;
    }

    public void setHasError(boolean hasError) {
        this._hasError = hasError;
    }

    public boolean hasError() {
        return this._hasError;
    }

    public void killCache() {
    }

    public void setSessionId(String id) {
    }

    public void setPrivateCache(boolean isPrivate) {
    }

    public void setNoCache(boolean isPrivate) {
    }

    public void close() throws IOException {
        WriteStream out = this._out;
        this._out = null;
        if (out != null) {
            out.close();
        }
    }

    public void flushResponse() throws IOException {
        int ch;
        this._out.flush();
        ReadStream rs = this._tempStream.openRead();
        PrintWriter out = this._response.getWriter();
        while ((ch = rs.readChar()) >= 0) {
            out.write((char)ch);
        }
        rs.close();
    }

    public String complete() throws IOException {
        int ch;
        WriteStream out = this._out;
        this._out = null;
        if (out != null) {
            out.flush();
        }
        ReadStream rs = this._tempStream.openRead();
        StringBuilder sb = new StringBuilder();
        while ((ch = rs.readChar()) >= 0) {
            sb.append((char)ch);
        }
        rs.close();
        return sb.toString();
    }
}

