/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import com.caucho.jsf.html.BaseRenderer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.html.HtmlColumn;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

class HtmlDataTableRenderer
extends BaseRenderer {
    public static final Renderer RENDERER = new HtmlDataTableRenderer();

    HtmlDataTableRenderer() {
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIComponent caption;
        ResponseWriter out = context.getResponseWriter();
        String bgcolor = null;
        int border = -1;
        String captionClass = null;
        String captionStyle = null;
        String cellpadding = null;
        String cellspacing = null;
        String columnClasses = null;
        String dir = null;
        String frame = null;
        String lang = null;
        String onclick = null;
        String ondblclick = null;
        String onkeydown = null;
        String onkeypress = null;
        String onkeyup = null;
        String onmousedown = null;
        String onmousemove = null;
        String onmouseout = null;
        String onmouseover = null;
        String onmouseup = null;
        String rules = null;
        String style = null;
        String styleClass = null;
        String summary = null;
        String title = null;
        String width = null;
        String id = component.getId();
        if (component instanceof HtmlDataTable) {
            HtmlDataTable html = (HtmlDataTable)component;
            bgcolor = html.getBgcolor();
            border = html.getBorder();
            captionClass = html.getCaptionClass();
            captionStyle = html.getCaptionStyle();
            cellpadding = html.getCellpadding();
            cellspacing = html.getCellspacing();
            columnClasses = html.getColumnClasses();
            dir = html.getDir();
            frame = html.getFrame();
            lang = html.getLang();
            onclick = html.getOnclick();
            ondblclick = html.getOndblclick();
            onkeydown = html.getOnkeydown();
            onkeypress = html.getOnkeypress();
            onkeyup = html.getOnkeyup();
            onmousedown = html.getOnmousedown();
            onmousemove = html.getOnmousemove();
            onmouseout = html.getOnmouseout();
            onmouseover = html.getOnmouseover();
            onmouseup = html.getOnmouseup();
            rules = html.getRules();
            style = html.getStyle();
            styleClass = html.getStyleClass();
            summary = html.getSummary();
            title = html.getTitle();
            width = html.getWidth();
        } else {
            Map attrMap = component.getAttributes();
            bgcolor = (String)attrMap.get("bgcolor");
            captionClass = (String)attrMap.get("captionClass");
            captionStyle = (String)attrMap.get("captionStyle");
            style = (String)attrMap.get("style");
            styleClass = (String)attrMap.get("styleClass");
        }
        String[] columnClassArray = null;
        if (columnClasses != null && (columnClassArray = columnClasses.split("[ \t,]+")).length == 0) {
            columnClassArray = null;
        }
        out.startElement("table", component);
        if (id != null && !id.startsWith("j_id")) {
            out.writeAttribute("id", (Object)component.getClientId(context), "id");
        }
        if (bgcolor != null) {
            out.writeAttribute("bgcolor", (Object)bgcolor, "bgcolor");
        }
        if (border >= 0) {
            out.writeAttribute("border", (Object)border, "border");
        }
        if (cellpadding != null) {
            out.writeAttribute("cellpadding", (Object)cellpadding, "cellpadding");
        }
        if (cellspacing != null) {
            out.writeAttribute("cellspacing", (Object)cellspacing, "cellspacing");
        }
        if (dir != null) {
            out.writeAttribute("dir", (Object)dir, "dir");
        }
        if (frame != null) {
            out.writeAttribute("frame", (Object)frame, "frame");
        }
        if (lang != null) {
            out.writeAttribute("lang", (Object)lang, "lang");
        }
        if (onclick != null) {
            out.writeAttribute("onclick", (Object)onclick, "onclick");
        }
        if (ondblclick != null) {
            out.writeAttribute("ondblclick", (Object)ondblclick, "ondblclick");
        }
        if (onkeydown != null) {
            out.writeAttribute("onkeydown", (Object)onkeydown, "onkeydown");
        }
        if (onkeypress != null) {
            out.writeAttribute("onkeypress", (Object)onkeypress, "onkeypress");
        }
        if (onkeyup != null) {
            out.writeAttribute("onkeyup", (Object)onkeyup, "onkeyup");
        }
        if (onmousedown != null) {
            out.writeAttribute("onmousedown", (Object)onmousedown, "onmousedown");
        }
        if (onmousemove != null) {
            out.writeAttribute("onmousemove", (Object)onmousemove, "onmousemove");
        }
        if (onmouseout != null) {
            out.writeAttribute("onmouseout", (Object)onmouseout, "onmouseout");
        }
        if (onmouseover != null) {
            out.writeAttribute("onmouseover", (Object)onmouseover, "onmouseover");
        }
        if (onmouseup != null) {
            out.writeAttribute("onmouseup", (Object)onmouseup, "onmouseup");
        }
        if (rules != null) {
            out.writeAttribute("rules", (Object)rules, "rules");
        }
        if (style != null) {
            out.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (summary != null) {
            out.writeAttribute("summary", (Object)summary, "summary");
        }
        if (title != null) {
            out.writeAttribute("title", (Object)title, "title");
        }
        if (width != null) {
            out.writeAttribute("width", (Object)width, "width");
        }
        if ((caption = component.getFacet("caption")) != null && caption.isRendered()) {
            out.startElement("caption", caption);
            if (captionClass != null) {
                out.writeAttribute("class", (Object)captionClass, "captionClass");
            }
            if (captionStyle != null) {
                out.writeAttribute("style", (Object)captionStyle, "captionStyle");
            }
            caption.encodeBegin(context);
            caption.encodeChildren(context);
            caption.encodeEnd(context);
            out.endElement("caption");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UIComponent footer;
        int size;
        String rowClasses;
        String columnClasses;
        String footerClass;
        String headerClass;
        int first = 0;
        int rows = 0;
        UIData uiData = (UIData)component;
        ResponseWriter out = context.getResponseWriter();
        if (component instanceof HtmlDataTable) {
            HtmlDataTable html = (HtmlDataTable)component;
            headerClass = html.getHeaderClass();
            footerClass = html.getFooterClass();
            columnClasses = html.getColumnClasses();
            rowClasses = html.getRowClasses();
            first = html.getFirst();
            rows = html.getRows();
        } else {
            Map attrMap = component.getAttributes();
            headerClass = (String)attrMap.get("headerClass");
            footerClass = (String)attrMap.get("footerClass");
            columnClasses = (String)attrMap.get("columnClasses");
            rowClasses = (String)attrMap.get("rowClasses");
        }
        String[] columnClassArray = null;
        if (columnClasses != null && (columnClassArray = columnClasses.split("[ \t,]+")).length == 0) {
            columnClassArray = null;
        }
        String[] rowClassArray = null;
        if (rowClasses != null && (rowClassArray = rowClasses.split("[ \t,]+")).length == 0) {
            rowClassArray = null;
        }
        if ((size = component.getChildCount()) == 0) {
            return;
        }
        int columns = size;
        List children = component.getChildren();
        boolean hasColumnHeader = false;
        boolean hasColumnFooter = false;
        for (int i = 0; i < size; ++i) {
            UIComponent child = (UIComponent)children.get(i);
            if (!(child instanceof UIComponent)) continue;
            if (child.getFacet("header") != null) {
                hasColumnHeader = true;
            }
            if (child.getFacet("footer") == null) continue;
            hasColumnFooter = true;
        }
        UIComponent header = component.getFacet("header");
        if (header != null && header.isRendered() || hasColumnHeader) {
            out.startElement("thead", component);
        }
        if (header != null && header.isRendered()) {
            out.startElement("tr", header);
            out.startElement("th", header);
            if (headerClass != null) {
                out.writeAttribute("class", (Object)headerClass, "headerClass");
            }
            if (columns > 0) {
                out.writeAttribute("colspan", (Object)columns, "columns");
            }
            out.writeAttribute("scope", (Object)"colgroup", "scope");
            header.encodeBegin(context);
            header.encodeChildren(context);
            header.encodeEnd(context);
            out.endElement("th");
            out.endElement("tr");
        }
        if (hasColumnHeader) {
            out.startElement("tr", component);
            for (int i = 0; i < size; ++i) {
                String columnHeaderClass;
                UIComponent child = (UIComponent)children.get(i);
                if (!(child instanceof UIColumn)) continue;
                out.startElement("th", child);
                if (child instanceof HtmlColumn) {
                    HtmlColumn htmlColumn = (HtmlColumn)child;
                    columnHeaderClass = htmlColumn.getHeaderClass();
                } else {
                    Map attributes = child.getAttributes();
                    columnHeaderClass = (String)attributes.get("headerClass");
                }
                if (columnHeaderClass != null) {
                    out.writeAttribute("class", (Object)columnHeaderClass, "headerClass");
                } else if (headerClass != null) {
                    out.writeAttribute("class", (Object)headerClass, "headerClass");
                }
                out.writeAttribute("scope", (Object)"col", "scope");
                UIComponent childHeader = child.getFacet("header");
                if (childHeader != null) {
                    childHeader.encodeBegin(context);
                    childHeader.encodeChildren(context);
                    childHeader.encodeEnd(context);
                }
                out.endElement("th");
            }
            out.endElement("tr");
        }
        if (header != null && header.isRendered() || hasColumnHeader) {
            out.endElement("thead");
        }
        if ((footer = component.getFacet("footer")) != null && footer.isRendered() || hasColumnFooter) {
            out.startElement("tfoot", component);
        }
        if (footer != null && footer.isRendered()) {
            out.startElement("tr", footer);
            out.startElement("td", footer);
            if (columns > 1) {
                out.writeAttribute("colspan", (Object)columns, "columns");
            }
            if (footerClass != null) {
                out.writeAttribute("class", (Object)footerClass, "footerClass");
            }
            footer.encodeBegin(context);
            footer.encodeChildren(context);
            footer.encodeEnd(context);
            out.endElement("td");
            out.endElement("tr");
        }
        if (hasColumnFooter) {
            out.startElement("tr", component);
            for (int i = 0; i < size; ++i) {
                String columnFooterClass;
                UIComponent child = (UIComponent)children.get(i);
                if (!(child instanceof UIComponent)) continue;
                if (child instanceof HtmlColumn) {
                    HtmlColumn htmlColumn = (HtmlColumn)child;
                    columnFooterClass = htmlColumn.getFooterClass();
                } else {
                    Map attributes = child.getAttributes();
                    columnFooterClass = (String)attributes.get("footerClass");
                }
                out.startElement("td", child);
                if (columnFooterClass != null) {
                    out.writeAttribute("class", (Object)columnFooterClass, "footerClass");
                } else if (footerClass != null) {
                    out.writeAttribute("class", (Object)footerClass, "headerClass");
                }
                UIComponent childFooter = child.getFacet("footer");
                if (childFooter != null) {
                    childFooter.encodeBegin(context);
                    childFooter.encodeChildren(context);
                    childFooter.encodeEnd(context);
                }
                out.endElement("td");
            }
            out.endElement("tr");
        }
        if (footer != null && footer.isRendered() || hasColumnFooter) {
            out.endElement("tfoot");
        }
        int dataCount = uiData.getRowCount();
        if (rows > 0 && first + rows < dataCount) {
            dataCount = first + rows;
        }
        if (dataCount - first > 0) {
            out.startElement("tbody", (UIComponent)uiData);
            for (int row = first; row < dataCount; ++row) {
                uiData.setRowIndex(row);
                out.startElement("tr", (UIComponent)uiData);
                if (rowClassArray != null) {
                    String v = rowClassArray[row % rowClassArray.length];
                    out.writeAttribute("class", (Object)v, "rowClasses");
                }
                for (int i = 0; i < size; ++i) {
                    UIComponent child = (UIComponent)children.get(i);
                    if (!child.isRendered()) continue;
                    out.startElement("td", child);
                    if (columnClassArray != null) {
                        String v = columnClassArray[i % columnClassArray.length];
                        out.writeAttribute("class", (Object)v, "columnClasses");
                    }
                    if (child instanceof UIColumn) {
                        int subCount = child.getChildCount();
                        for (int j = 0; j < subCount; ++j) {
                            UIComponent subChild = (UIComponent)child.getChildren().get(j);
                            subChild.encodeBegin(context);
                            subChild.encodeChildren(context);
                            subChild.encodeEnd(context);
                        }
                    } else {
                        child.encodeBegin(context);
                        child.encodeChildren(context);
                        child.encodeEnd(context);
                    }
                    out.endElement("td");
                }
                out.endElement("tr");
            }
            out.endElement("tbody");
        }
        uiData.setRowIndex(-1);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.endElement("table");
    }

    public String toString() {
        return "HtmlPanelGridRenderer[]";
    }
}

