/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import com.caucho.jsf.html.BaseRenderer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlFormRenderer
extends BaseRenderer {
    private static final Logger log = Logger.getLogger(HtmlFormRenderer.class.getName());
    public static final Renderer RENDERER = new HtmlFormRenderer();

    HtmlFormRenderer() {
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        ExternalContext ext = context.getExternalContext();
        Map paramMap = ext.getRequestParameterMap();
        String value = (String)paramMap.get(clientId);
        ((UIForm)component).setSubmitted(value != null);
        if (log.isLoggable(Level.FINE) && value != null) {
            log.fine("JSF[" + context.getViewRoot().getViewId() + "] decoding form data for '" + clientId + "'");
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String title;
        String target;
        String styleClass;
        String style;
        String onsubmit;
        String onreset;
        String onmouseup;
        String onmouseover;
        String onmouseout;
        String onmousemove;
        String onmousedown;
        String onkeyup;
        String onkeypress;
        String onkeydown;
        String ondblclick;
        String onclick;
        String lang;
        String enctype;
        String dir;
        String acceptcharset;
        String accept;
        ResponseWriter out = context.getResponseWriter();
        String id = component.getId();
        if (component instanceof HtmlForm) {
            HtmlForm htmlForm = (HtmlForm)component;
            accept = htmlForm.getAccept();
            acceptcharset = htmlForm.getAcceptcharset();
            dir = htmlForm.getDir();
            enctype = htmlForm.getEnctype();
            lang = htmlForm.getLang();
            onclick = htmlForm.getOnclick();
            ondblclick = htmlForm.getOndblclick();
            onkeydown = htmlForm.getOnkeydown();
            onkeypress = htmlForm.getOnkeypress();
            onkeyup = htmlForm.getOnkeyup();
            onmousedown = htmlForm.getOnmousedown();
            onmousemove = htmlForm.getOnmousemove();
            onmouseout = htmlForm.getOnmouseout();
            onmouseover = htmlForm.getOnmouseover();
            onmouseup = htmlForm.getOnmouseup();
            onreset = htmlForm.getOnreset();
            onsubmit = htmlForm.getOnsubmit();
            style = htmlForm.getStyle();
            styleClass = htmlForm.getStyleClass();
            target = htmlForm.getTarget();
            title = htmlForm.getTitle();
        } else {
            Map attrMap = component.getAttributes();
            accept = (String)attrMap.get("accept");
            acceptcharset = (String)attrMap.get("acceptcharset");
            dir = (String)attrMap.get("dir");
            enctype = (String)attrMap.get("enctype");
            lang = (String)attrMap.get("lang");
            onclick = (String)attrMap.get("onclick");
            ondblclick = (String)attrMap.get("ondblclick");
            String onfocus = (String)attrMap.get("onfocus");
            onkeydown = (String)attrMap.get("onkeydown");
            onkeypress = (String)attrMap.get("onkeypress");
            onkeyup = (String)attrMap.get("onkeyup");
            onmousedown = (String)attrMap.get("onmousedown");
            onmousemove = (String)attrMap.get("onmousemove");
            onmouseout = (String)attrMap.get("onmouseout");
            onmouseover = (String)attrMap.get("onmouseover");
            onmouseup = (String)attrMap.get("onmouseup");
            onreset = (String)attrMap.get("onreset");
            onsubmit = (String)attrMap.get("onsubmit");
            style = (String)attrMap.get("style");
            styleClass = (String)attrMap.get("styleClass");
            target = (String)attrMap.get("target");
            title = (String)attrMap.get("title");
        }
        out.startElement("form", component);
        String clientId = component.getClientId(context);
        out.writeAttribute("name", (Object)clientId, "name");
        out.writeAttribute("id", (Object)clientId, "id");
        out.writeAttribute("method", (Object)"post", "method");
        String viewId = context.getViewRoot().getViewId();
        Application app = context.getApplication();
        ExternalContext extContext = context.getExternalContext();
        ViewHandler view = app.getViewHandler();
        String action = view.getActionURL(context, viewId);
        String encodedAction = extContext.encodeActionURL(action);
        out.writeAttribute("action", (Object)encodedAction, "action");
        if (accept != null) {
            out.writeAttribute("accept", (Object)accept, "accept");
        }
        if (acceptcharset != null) {
            out.writeAttribute("accept-charset", (Object)acceptcharset, "acceptcharset");
        }
        if (dir != null) {
            out.writeAttribute("dir", (Object)dir, "dir");
        }
        if (enctype != null) {
            out.writeAttribute("enctype", (Object)enctype, "enctype");
        } else {
            out.writeAttribute("enctype", (Object)"application/x-www-form-urlencoded", "enctype");
        }
        if (lang != null) {
            out.writeAttribute("lang", (Object)lang, "lang");
        }
        if (onclick != null) {
            out.writeAttribute("onclick", (Object)onclick, "onclick");
        }
        if (ondblclick != null) {
            out.writeAttribute("ondblclick", (Object)ondblclick, "ondblclick");
        }
        if (onkeydown != null) {
            out.writeAttribute("onkeydown", (Object)onkeydown, "onkeydown");
        }
        if (onkeypress != null) {
            out.writeAttribute("onkeypress", (Object)onkeypress, "onkeypress");
        }
        if (onkeyup != null) {
            out.writeAttribute("onkeyup", (Object)onkeyup, "onkeyup");
        }
        if (onmousedown != null) {
            out.writeAttribute("onmousedown", (Object)onmousedown, "onmousedown");
        }
        if (onmousemove != null) {
            out.writeAttribute("onmousemove", (Object)onmousemove, "onmousemove");
        }
        if (onmouseout != null) {
            out.writeAttribute("onmouseout", (Object)onmouseout, "onmouseout");
        }
        if (onmouseover != null) {
            out.writeAttribute("onmouseover", (Object)onmouseover, "onmouseover");
        }
        if (onmouseup != null) {
            out.writeAttribute("onmouseup", (Object)onmouseup, "onmouseup");
        }
        if (onreset != null) {
            out.writeAttribute("onreset", (Object)onreset, "onreset");
        }
        if (onsubmit != null) {
            out.writeAttribute("onsubmit", (Object)onsubmit, "onsubmit");
        }
        if (style != null) {
            out.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, "class");
        }
        if (target != null) {
            out.writeAttribute("target", (Object)target, "target");
        }
        if (title != null) {
            out.writeAttribute("title", (Object)title, "title");
        }
        out.write("\n");
        out.startElement("input", component);
        out.writeAttribute("type", (Object)"hidden", "type");
        out.writeAttribute("name", (Object)component.getClientId(context), "name");
        out.endElement("input");
        out.write("\n");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Set<String> params;
        ViewHandler handler = context.getApplication().getViewHandler();
        ResponseWriter out = context.getResponseWriter();
        Set<String> links = HtmlFormRenderer.findCommandLinkHiddenFieldSet(context, component.getClientId(context), false);
        if (links != null) {
            for (String link : links) {
                out.startElement("input", component);
                out.writeAttribute("type", (Object)"hidden", "type");
                out.writeAttribute("name", (Object)link, "name");
                out.endElement("input");
            }
        }
        if ((params = HtmlFormRenderer.findCommandLinkParamSet(context, component.getClientId(context), false)) != null) {
            for (String param : params) {
                out.startElement("input", component);
                out.writeAttribute("name", (Object)param, "name");
                out.writeAttribute("id", (Object)param, "id");
                out.writeAttribute("type", (Object)"hidden", "type");
                out.endElement("input");
            }
        }
        handler.writeState(context);
        out.endElement("form");
        out.write("\n");
    }

    static void addCommandLinkParam(FacesContext context, String formClientId, String name) {
        HtmlFormRenderer.findCommandLinkParamSet(context, formClientId, true).add(name);
    }

    static void addCommandLinkHiddenField(FacesContext context, String formClientId, String name) {
        HtmlFormRenderer.findCommandLinkHiddenFieldSet(context, formClientId, true).add(name);
    }

    private static Set<String> findCommandLinkParamSet(FacesContext context, String formClientId, boolean create) {
        String setKey = "com.caucho.jsf.html.form." + formClientId + ".commandLinkParams";
        Map requestMap = context.getExternalContext().getRequestMap();
        HashSet params = (HashSet)requestMap.get(setKey);
        if (params == null && create) {
            params = new HashSet();
            requestMap.put(setKey, params);
        }
        return params;
    }

    private static Set<String> findCommandLinkHiddenFieldSet(FacesContext context, String formClientId, boolean create) {
        String setKey = "com.caucho.jsf.html.form." + formClientId + ".commandLinks";
        Map requestMap = context.getExternalContext().getRequestMap();
        HashSet links = (HashSet)requestMap.get(setKey);
        if (links == null && create) {
            links = new HashSet();
            requestMap.put(setKey, links);
        }
        return links;
    }
}

