/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import com.caucho.jsf.html.BaseRenderer;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

class HtmlInputTextRenderer
extends BaseRenderer {
    private static final Logger log = Logger.getLogger(HtmlInputTextRenderer.class.getName());
    public static final Renderer RENDERER = new HtmlInputTextRenderer();

    HtmlInputTextRenderer() {
    }

    public boolean getRendersChildren() {
        return false;
    }

    public void decode(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        ExternalContext ext = context.getExternalContext();
        Map paramMap = ext.getRequestParameterMap();
        String value = (String)paramMap.get(clientId);
        if (value != null) {
            ((EditableValueHolder)component).setSubmittedValue((Object)value);
            if (log.isLoggable(Level.FINER)) {
                log.finer("JSF[" + context.getViewRoot().getViewId() + "] h:inputText[" + clientId + "] =" + value);
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        Object value;
        String title;
        String tabindex;
        String styleClass;
        String style;
        int size;
        boolean readonly;
        String onselect;
        String onmouseup;
        String onmouseover;
        String onmouseout;
        String onmousemove;
        String onmousedown;
        String onkeyup;
        String onkeypress;
        String onkeydown;
        String onfocus;
        String ondblclick;
        String onclick;
        String onchange;
        String onblur;
        int maxlength;
        String lang;
        boolean disabled;
        String dir;
        String alt;
        String autocomplete;
        String accesskey;
        ResponseWriter out = context.getResponseWriter();
        String id = component.getId();
        if (component instanceof HtmlInputText) {
            HtmlInputText htmlInput = (HtmlInputText)component;
            accesskey = htmlInput.getAccesskey();
            autocomplete = htmlInput.getAutocomplete();
            alt = htmlInput.getAlt();
            dir = htmlInput.getDir();
            disabled = htmlInput.isDisabled();
            lang = htmlInput.getLang();
            maxlength = htmlInput.getMaxlength();
            onblur = htmlInput.getOnblur();
            onchange = htmlInput.getOnchange();
            onclick = htmlInput.getOnclick();
            ondblclick = htmlInput.getOndblclick();
            onfocus = htmlInput.getOnfocus();
            onkeydown = htmlInput.getOnkeydown();
            onkeypress = htmlInput.getOnkeypress();
            onkeyup = htmlInput.getOnkeyup();
            onmousedown = htmlInput.getOnmousedown();
            onmousemove = htmlInput.getOnmousemove();
            onmouseout = htmlInput.getOnmouseout();
            onmouseover = htmlInput.getOnmouseover();
            onmouseup = htmlInput.getOnmouseup();
            onselect = htmlInput.getOnselect();
            readonly = htmlInput.isReadonly();
            size = htmlInput.getSize();
            style = htmlInput.getStyle();
            styleClass = htmlInput.getStyleClass();
            tabindex = htmlInput.getTabindex();
            title = htmlInput.getTitle();
            value = htmlInput.getValue();
        } else {
            Map attrMap = component.getAttributes();
            accesskey = (String)attrMap.get("accesskey");
            alt = (String)attrMap.get("alt");
            autocomplete = (String)attrMap.get("autocomplete");
            dir = (String)attrMap.get("dir");
            disabled = (Boolean)attrMap.get("disabled");
            lang = (String)attrMap.get("lang");
            maxlength = (Integer)attrMap.get("maxlength");
            onblur = (String)attrMap.get("onblur");
            onchange = (String)attrMap.get("onchange");
            onclick = (String)attrMap.get("onclick");
            ondblclick = (String)attrMap.get("ondblclick");
            onfocus = (String)attrMap.get("onfocus");
            onkeydown = (String)attrMap.get("onkeydown");
            onkeypress = (String)attrMap.get("onkeypress");
            onkeyup = (String)attrMap.get("onkeyup");
            onmousedown = (String)attrMap.get("onmousedown");
            onmousemove = (String)attrMap.get("onmousemove");
            onmouseout = (String)attrMap.get("onmouseout");
            onmouseover = (String)attrMap.get("onmouseover");
            onmouseup = (String)attrMap.get("onmouseup");
            onselect = (String)attrMap.get("onselect");
            readonly = (Boolean)attrMap.get("readonly");
            size = (Integer)attrMap.get("size");
            style = (String)attrMap.get("style");
            styleClass = (String)attrMap.get("styleClass");
            tabindex = (String)attrMap.get("tabindex");
            title = (String)attrMap.get("title");
            value = attrMap.get("value");
        }
        out.startElement("input", component);
        out.writeAttribute("name", (Object)component.getClientId(context), "name");
        out.writeAttribute("type", (Object)"text", "type");
        if (id != null && !id.startsWith("j_id")) {
            out.writeAttribute("id", (Object)component.getClientId(context), "id");
        }
        if (accesskey != null) {
            out.writeAttribute("accesskey", (Object)accesskey, "accesskey");
        }
        if (alt != null) {
            out.writeAttribute("alt", (Object)alt, "alt");
        }
        if ("off".equals(autocomplete)) {
            out.writeAttribute("autocomplete", (Object)"off", "autocomplete");
        }
        if (dir != null) {
            out.writeAttribute("dir", (Object)dir, "dir");
        }
        if (disabled) {
            out.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (lang != null) {
            out.writeAttribute("lang", (Object)lang, "lang");
        }
        if (maxlength > 0) {
            out.writeAttribute("maxlength", (Object)String.valueOf(maxlength), "maxlength");
        }
        if (onblur != null) {
            out.writeAttribute("onblur", (Object)onblur, "onblur");
        }
        if (onchange != null) {
            out.writeAttribute("onchange", (Object)onchange, "onchange");
        }
        if (onclick != null) {
            out.writeAttribute("onclick", (Object)onclick, "onclick");
        }
        if (ondblclick != null) {
            out.writeAttribute("ondblclick", (Object)ondblclick, "ondblclick");
        }
        if (onfocus != null) {
            out.writeAttribute("onfocus", (Object)onfocus, "onfocus");
        }
        if (onkeydown != null) {
            out.writeAttribute("onkeydown", (Object)onkeydown, "onkeydown");
        }
        if (onkeypress != null) {
            out.writeAttribute("onkeypress", (Object)onkeypress, "onkeypress");
        }
        if (onkeyup != null) {
            out.writeAttribute("onkeyup", (Object)onkeyup, "onkeyup");
        }
        if (onmousedown != null) {
            out.writeAttribute("onmousedown", (Object)onmousedown, "onmousedown");
        }
        if (onmousemove != null) {
            out.writeAttribute("onmousemove", (Object)onmousemove, "onmousemove");
        }
        if (onmouseout != null) {
            out.writeAttribute("onmouseout", (Object)onmouseout, "onmouseout");
        }
        if (onmouseover != null) {
            out.writeAttribute("onmouseover", (Object)onmouseover, "onmouseover");
        }
        if (onmouseup != null) {
            out.writeAttribute("onmouseup", (Object)onmouseup, "onmouseup");
        }
        if (onselect != null) {
            out.writeAttribute("onselect", (Object)onselect, "onselect");
        }
        if (readonly) {
            out.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (size > 0) {
            out.writeAttribute("size", (Object)String.valueOf(size), "size");
        }
        if (style != null) {
            out.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, "class");
        }
        if (tabindex != null) {
            out.writeAttribute("tabindex", (Object)tabindex, "tabindex");
        }
        if (title != null) {
            out.writeAttribute("title", (Object)title, "title");
        }
        out.writeAttribute("value", (Object)this.toString(context, component, value), "value");
        out.endElement("input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public String toString() {
        return "HtmlInputTextRenderer[]";
    }
}

