/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.component.html.HtmlMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

class HtmlMessageRenderer
extends Renderer {
    public static final Renderer RENDERER = new HtmlMessageRenderer();

    HtmlMessageRenderer() {
    }

    public boolean getRendersChildren() {
        return false;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        Iterator iter;
        String warnStyle;
        String warnClass;
        boolean tooltip;
        String title;
        String styleClass;
        String style;
        String lang;
        String infoStyle;
        String infoClass;
        String forValue;
        String dir;
        String fatalStyle;
        String fatalClass;
        String errorStyle;
        String errorClass;
        boolean isShowDetail;
        boolean isShowSummary;
        UIMessage uiMessage = (UIMessage)component;
        ResponseWriter out = context.getResponseWriter();
        String id = component.getId();
        if (component instanceof HtmlMessage) {
            HtmlMessage htmlComp = (HtmlMessage)component;
            isShowSummary = htmlComp.isShowSummary();
            isShowDetail = htmlComp.isShowDetail();
            errorClass = htmlComp.getErrorClass();
            errorStyle = htmlComp.getErrorStyle();
            fatalClass = htmlComp.getFatalClass();
            fatalStyle = htmlComp.getFatalStyle();
            dir = htmlComp.getDir();
            forValue = htmlComp.getFor();
            infoClass = htmlComp.getInfoClass();
            infoStyle = htmlComp.getInfoStyle();
            lang = htmlComp.getLang();
            style = htmlComp.getStyle();
            styleClass = htmlComp.getStyleClass();
            title = htmlComp.getTitle();
            tooltip = htmlComp.isTooltip();
            warnClass = htmlComp.getWarnClass();
            warnStyle = htmlComp.getWarnStyle();
        } else {
            Map attrMap = component.getAttributes();
            isShowSummary = (Boolean)attrMap.get("showSummary");
            isShowDetail = (Boolean)attrMap.get("showDetail");
            dir = (String)attrMap.get("dir");
            forValue = (String)attrMap.get("for");
            errorClass = (String)attrMap.get("errorClass");
            errorStyle = (String)attrMap.get("errorStyle");
            fatalClass = (String)attrMap.get("fatalClass");
            fatalStyle = (String)attrMap.get("fatalStyle");
            infoClass = (String)attrMap.get("infoClass");
            infoStyle = (String)attrMap.get("infoStyle");
            warnClass = (String)attrMap.get("warnClass");
            warnStyle = (String)attrMap.get("warnStyle");
            lang = (String)attrMap.get("lang");
            style = (String)attrMap.get("style");
            styleClass = (String)attrMap.get("styleClass");
            title = (String)attrMap.get("title");
            tooltip = (Boolean)attrMap.get("tooltip");
        }
        UIComponent forComponent = component.findComponent(forValue);
        if (forComponent != null && (iter = context.getMessages(forComponent.getClientId(context))).hasNext()) {
            boolean hasSpan;
            FacesMessage msg = (FacesMessage)iter.next();
            if (FacesMessage.SEVERITY_ERROR.equals(msg.getSeverity())) {
                if (errorClass != null) {
                    styleClass = errorClass;
                }
                if (errorStyle != null) {
                    style = errorStyle;
                }
            } else if (FacesMessage.SEVERITY_FATAL.equals(msg.getSeverity())) {
                if (fatalClass != null) {
                    styleClass = fatalClass;
                }
                if (fatalStyle != null) {
                    style = fatalStyle;
                }
            } else if (FacesMessage.SEVERITY_INFO.equals(msg.getSeverity())) {
                if (infoClass != null) {
                    styleClass = infoClass;
                }
                if (errorStyle != null) {
                    style = infoStyle;
                }
            } else if (FacesMessage.SEVERITY_WARN.equals(msg.getSeverity())) {
                if (warnClass != null) {
                    styleClass = warnClass;
                }
                if (warnStyle != null) {
                    style = warnStyle;
                }
            }
            boolean bl = hasSpan = dir != null || lang != null || style != null || styleClass != null || title != null || tooltip;
            if (hasSpan) {
                out.startElement("span", component);
            }
            if (dir != null) {
                out.writeAttribute("dir", (Object)dir, "dir");
            }
            if (lang != null) {
                out.writeAttribute("lang", (Object)lang, "lang");
            }
            if (style != null) {
                out.writeAttribute("style", (Object)style, "style");
            }
            if (styleClass != null) {
                out.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            if (isShowSummary) {
                if (tooltip && isShowDetail) {
                    out.writeAttribute("title", (Object)msg.getSummary(), "title");
                } else if (title != null) {
                    out.writeAttribute("title", (Object)title, "title");
                    out.writeText((Object)msg.getSummary(), "summary");
                } else {
                    out.writeText((Object)msg.getSummary(), "summary");
                }
            }
            if (isShowDetail) {
                out.writeText((Object)msg.getDetail(), "detail");
            }
            if (hasSpan) {
                out.endElement("span");
            }
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public String toString() {
        return "HtmlMessageRenderer[]";
    }
}

