/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import com.caucho.jsf.html.BaseRenderer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

class HtmlOutputLinkRenderer
extends BaseRenderer {
    public static final Renderer RENDERER = new HtmlOutputLinkRenderer();

    HtmlOutputLinkRenderer() {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        Object value;
        String title;
        String styleClass;
        String style;
        String target;
        String lang;
        String dir;
        ResponseWriter out = context.getResponseWriter();
        String id = component.getId();
        if (component instanceof HtmlOutputLink) {
            HtmlOutputLink htmlOutput = (HtmlOutputLink)component;
            dir = htmlOutput.getDir();
            lang = htmlOutput.getLang();
            target = htmlOutput.getTarget();
            style = htmlOutput.getStyle();
            styleClass = htmlOutput.getStyleClass();
            title = htmlOutput.getTitle();
            value = htmlOutput.getValue();
        } else {
            Map attrMap = component.getAttributes();
            dir = (String)attrMap.get("dir");
            lang = (String)attrMap.get("lang");
            target = (String)attrMap.get("target");
            style = (String)attrMap.get("style");
            styleClass = (String)attrMap.get("styleClass");
            title = (String)attrMap.get("title");
            value = attrMap.get("value");
        }
        out.startElement("a", component);
        if (id != null && !id.startsWith("j_id")) {
            out.writeAttribute("id", (Object)component.getClientId(context), "id");
        }
        if (dir != null) {
            out.writeAttribute("dir", (Object)dir, "dir");
        }
        if (lang != null) {
            out.writeAttribute("lang", (Object)lang, "lang");
        }
        if (style != null) {
            out.writeAttribute("style", (Object)style, "style");
        }
        if (target != null) {
            out.writeAttribute("target", (Object)lang, "target");
        }
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, "class");
        }
        if (title != null) {
            out.writeAttribute("title", (Object)title, "title");
        }
        int childCount = component.getChildCount();
        String href = this.toString(context, component, value);
        StringBuilder sb = null;
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = (UIComponent)component.getChildren().get(i);
            if (!(child instanceof UIParameter)) continue;
            if (sb == null) {
                sb = new StringBuilder().append(href);
                if (href.indexOf(63) < 0) {
                    sb.append('?');
                } else {
                    sb.append('&');
                }
            } else {
                sb.append('&');
            }
            UIParameter param = (UIParameter)child;
            String name = param.getName();
            Object paramValue = param.getValue();
            if (name != null) {
                sb.append(name);
                sb.append('=');
            }
            sb.append(this.toString(context, (UIComponent)param, paramValue));
        }
        if (sb != null) {
            out.writeAttribute("href", (Object)sb.toString(), "href");
        } else {
            out.writeAttribute("href", (Object)href, "href");
        }
        if (childCount > 0) {
            List children = component.getChildren();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)children.get(i);
                if (child instanceof UIParameter || !child.isRendered()) continue;
                child.encodeBegin(context);
                child.encodeChildren(context);
                child.encodeEnd(context);
            }
        }
        out.endElement("a");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public String toString() {
        return "HtmlOutputTextRenderer[]";
    }
}

