/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import com.caucho.jsf.html.HtmlRenderer;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

class HtmlOutputTextRenderer
extends HtmlRenderer {
    public static final Renderer RENDERER = new HtmlOutputTextRenderer();

    HtmlOutputTextRenderer() {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        Object value;
        boolean escape;
        String title;
        String styleClass;
        String style;
        String lang;
        String dir;
        ResponseWriter out = context.getResponseWriter();
        String id = component.getId();
        if (component instanceof HtmlOutputText) {
            HtmlOutputText htmlOutput = (HtmlOutputText)component;
            dir = htmlOutput.getDir();
            lang = htmlOutput.getLang();
            style = htmlOutput.getStyle();
            styleClass = htmlOutput.getStyleClass();
            title = htmlOutput.getTitle();
            escape = htmlOutput.isEscape();
            value = htmlOutput.getValue();
        } else {
            Map attrMap = component.getAttributes();
            dir = (String)attrMap.get("dir");
            lang = (String)attrMap.get("lang");
            style = (String)attrMap.get("style");
            styleClass = (String)attrMap.get("styleClass");
            title = (String)attrMap.get("title");
            Boolean escapeValue = (Boolean)attrMap.get("escape");
            escape = escapeValue != null ? escapeValue : true;
            value = component instanceof UIOutput ? ((UIOutput)component).getValue() : attrMap.get("value");
        }
        boolean hasSpan = false;
        if (dir != null || lang != null || style != null || styleClass != null || id != null && !id.startsWith("j_id")) {
            hasSpan = true;
            out.startElement("span", component);
            if (id != null && !id.startsWith("j_id")) {
                out.writeAttribute("id", (Object)component.getClientId(context), "id");
            }
            if (dir != null) {
                out.writeAttribute("dir", (Object)dir, "dir");
            }
            if (lang != null) {
                out.writeAttribute("lang", (Object)lang, "dir");
            }
            if (style != null) {
                out.writeAttribute("style", (Object)style, "style");
            }
            if (styleClass != null) {
                out.writeAttribute("class", (Object)styleClass, "class");
            }
            if (title != null) {
                out.writeAttribute("title", (Object)title, "title");
            }
        }
        String string = this.toString(context, component, value);
        if (escape) {
            HtmlOutputTextRenderer.escapeText(out, string, "value");
        } else {
            out.write(string);
        }
        if (hasSpan) {
            out.endElement("span");
        }
    }

    public String toString() {
        return "HtmlOutputTextRenderer[]";
    }
}

