/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

class HtmlPanelGroupRenderer
extends Renderer {
    public static final Renderer RENDERER = new HtmlPanelGroupRenderer();

    HtmlPanelGroupRenderer() {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        int childCount;
        ResponseWriter out = context.getResponseWriter();
        String id = null;
        String layout = null;
        String style = null;
        String styleClass = null;
        if (component instanceof HtmlPanelGroup) {
            HtmlPanelGroup html = (HtmlPanelGroup)component;
            id = html.getId();
            layout = html.getLayout();
            style = html.getStyle();
            styleClass = html.getStyleClass();
        } else {
            Map attrMap = component.getAttributes();
            id = (String)attrMap.get("id");
            layout = (String)attrMap.get("layout");
            style = (String)attrMap.get("style");
            styleClass = (String)attrMap.get("styleClass");
        }
        boolean isDiv = "block".equals(layout);
        if (isDiv) {
            out.startElement("div", component);
        } else {
            out.startElement("span", component);
        }
        if (id != null) {
            out.writeAttribute("id", (Object)id, "id");
        }
        if (layout != null) {
            out.writeAttribute("layout", (Object)layout, "layout");
        }
        if (style != null) {
            out.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if ((childCount = component.getChildCount()) > 0) {
            List children = component.getChildren();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)children.get(i);
                if (!child.isRendered()) continue;
                child.encodeBegin(context);
                child.encodeChildren(context);
                child.encodeEnd(context);
            }
        }
        if (isDiv) {
            out.endElement("div");
        } else {
            out.endElement("span");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public String toString() {
        return "HtmlPanelGroupRenderer[]";
    }
}

