/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.html;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;

public class HtmlResponseWriter
extends ResponseWriter {
    private String _contentType;
    private String _encoding;
    private Writer _out;
    private boolean _inElement;

    HtmlResponseWriter(Writer out, String contentType, String encoding) {
        this._out = out;
        this._contentType = contentType;
        this._encoding = encoding;
    }

    public void write(char[] buffer, int offset, int length) throws IOException {
        if (this._inElement) {
            this.closeElement();
        }
        this._out.write(buffer, offset, length);
    }

    public void write(char ch) throws IOException {
        if (this._inElement) {
            this.closeElement();
        }
        this._out.write(ch);
    }

    public void write(String v) throws IOException {
        if (this._inElement) {
            this.closeElement();
        }
        this._out.write(v);
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getCharacterEncoding() {
        return this._encoding;
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (this._inElement) {
            this.closeElement();
        }
        this._out.write("<");
        this._out.write(name);
        this._inElement = true;
    }

    public void endElement(String name) throws IOException {
        if (this._inElement) {
            this.closeElement();
        }
        this._out.write("</");
        this._out.write(name);
        this._out.write(">");
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        this._out.write(32);
        this._out.write(name);
        this._out.write("=\"");
        this._out.write(String.valueOf(value));
        this._out.write("\"");
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        this.writeAttribute(name, value, property);
    }

    public void writeComment(Object comment) throws IOException {
        if (this._inElement) {
            this.closeElement();
        }
        this._out.write("<!--");
        this._out.write(String.valueOf(comment));
        this._out.write("-->");
    }

    public void writeText(Object text, String property) throws IOException {
        if (this._inElement) {
            this.closeElement();
        }
        this._out.write(String.valueOf(text));
    }

    public void writeText(char[] text, int offset, int length) throws IOException {
        if (this._inElement) {
            this.closeElement();
        }
        this._out.write(text, offset, length);
    }

    public ResponseWriter cloneWithWriter(Writer out) {
        return new HtmlResponseWriter(out, this._contentType, this._encoding);
    }

    private void closeElement() throws IOException {
        this._out.write(">");
        this._inElement = false;
    }

    public void close() throws IOException {
        this.flush();
        this._out.close();
    }

    public String toString() {
        return "HtmlResponseWriter[]";
    }
}

