/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.taglib;

import com.caucho.util.L10N;
import javax.el.ValueExpression;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionListener;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class ActionListenerTag
extends TagSupport {
    private static final L10N L = new L10N(ActionListenerTag.class);
    private ValueExpression _type;
    private ValueExpression _binding;

    public void setType(ValueExpression type) {
        this._type = type;
    }

    public void setBinding(ValueExpression binding) {
        this._binding = binding;
    }

    public int doStartTag() throws JspException {
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponentClassicTagBase parent = UIComponentClassicTagBase.getParentUIComponentClassicTagBase((PageContext)this.pageContext);
        if (parent == null) {
            throw new JspException(L.l("f:actionListener must be nested inside a UIComponent tag."));
        }
        UIComponent parentComp = parent.getComponentInstance();
        if (!(parentComp instanceof ActionSource)) {
            throw new JspException(L.l("f:actionListener must be nested inside an ActionSource UIComponent tag."));
        }
        ActionSource actionComp = (ActionSource)parentComp;
        ActionListener listener = null;
        if (parent.getCreated()) {
            String className;
            ValueExpression bindingExpr = null;
            if (this._binding != null) {
                bindingExpr = (ValueExpression)this._binding.getValue(context.getELContext());
            }
            if (listener == null && this._type != null && (className = (String)this._type.getValue(context.getELContext())) != null) {
                try {
                    Thread thread = Thread.currentThread();
                    ClassLoader loader = thread.getContextClassLoader();
                    Class<?> cl = Class.forName(className, false, loader);
                    listener = (ActionListener)cl.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new JspException((Throwable)e);
                }
            }
            if (listener == null) {
                throw new JspException(L.l("f:actionListener cannot create an actionListener"));
            }
            actionComp.addActionListener(listener);
            if (bindingExpr != null) {
                bindingExpr.setValue(context.getELContext(), listener);
            }
        }
        return 0;
    }
}

