/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.taglib;

import com.caucho.jsf.context.JspResponseWrapper;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;

public class FacesViewTag
extends UIComponentELTag {
    private static final L10N L = new L10N(FacesViewTag.class);
    private static final Logger log = Logger.getLogger(FacesViewTag.class.getName());
    private ValueExpression _renderKitId;
    private ValueExpression _locale;
    private MethodExpression _beforePhase;
    private MethodExpression _afterPhase;

    public String getComponentType() {
        return "javax.faces.ViewRoot";
    }

    public String getRendererType() {
        return null;
    }

    public void setRenderKitId(ValueExpression value) {
        this._renderKitId = value;
    }

    public void setLocale(ValueExpression value) {
        this._locale = value;
    }

    public void setBeforePhase(MethodExpression value) {
        this._beforePhase = value;
    }

    public void setAfterPhase(MethodExpression value) {
        this._afterPhase = value;
    }

    public int doStartTag() throws JspException {
        PageContext pageContext = this.pageContext;
        ServletResponse response = pageContext.getResponse();
        try {
            if (response instanceof JspResponseWrapper) {
                ((JspResponseWrapper)response).flushResponse();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        int doStartValue = super.doStartTag();
        FacesContext context = FacesContext.getCurrentInstance();
        pageContext.getResponse().setLocale(context.getViewRoot().getLocale());
        return doStartValue;
    }

    public int doEndTag() throws JspException {
        return super.doEndTag();
    }

    protected void setProperties(UIComponent component) {
        boolean isFiner = log.isLoggable(Level.FINER);
        UIViewRoot viewRoot = (UIViewRoot)component;
        if (this._renderKitId != null) {
            if (isFiner) {
                log.log(Level.FINER, L.l("{0}: setting renderKitId to {1}", (Object)viewRoot, (Object)this._renderKitId));
            }
            viewRoot.setValueExpression("renderKitId", this._renderKitId);
        }
        if (this._locale != null) {
            if (isFiner) {
                log.log(Level.FINE, L.l("{0}: setting locale to {1}", (Object)viewRoot, (Object)this._locale));
            }
            viewRoot.setValueExpression("locale", this._locale);
        }
        if (this._beforePhase != null) {
            viewRoot.addPhaseListener((PhaseListener)new BeforePhaseListenerAdapter(this._beforePhase));
        }
        if (this._afterPhase != null) {
            viewRoot.addPhaseListener((PhaseListener)new AfterPhaseListenerAdapter(this._afterPhase));
        }
    }

    public static abstract class AbstractPhaseListenerAdapter
    implements PhaseListener,
    StateHolder {
        protected MethodExpression _methodExpression;
        private boolean _transient;

        public AbstractPhaseListenerAdapter(MethodExpression methodExpression) {
            this._methodExpression = methodExpression;
        }

        public AbstractPhaseListenerAdapter() {
        }

        public void afterPhase(PhaseEvent event) {
        }

        public void beforePhase(PhaseEvent event) {
        }

        public PhaseId getPhaseId() {
            return PhaseId.ANY_PHASE;
        }

        public Object saveState(FacesContext context) {
            return this._methodExpression;
        }

        public void restoreState(FacesContext context, Object state) {
            this._methodExpression = (MethodExpression)state;
        }

        public boolean isTransient() {
            return this._transient;
        }

        public void setTransient(boolean isTransient) {
            this._transient = isTransient;
        }
    }

    public static class AfterPhaseListenerAdapter
    extends AbstractPhaseListenerAdapter {
        public AfterPhaseListenerAdapter() {
        }

        public AfterPhaseListenerAdapter(MethodExpression methodExpression) {
            super(methodExpression);
        }

        public void afterPhase(PhaseEvent event) {
            if (PhaseId.RESTORE_VIEW.getOrdinal() != event.getPhaseId().getOrdinal()) {
                this._methodExpression.invoke(FacesContext.getCurrentInstance().getELContext(), new Object[]{event});
            }
        }
    }

    public static class BeforePhaseListenerAdapter
    extends AbstractPhaseListenerAdapter {
        public BeforePhaseListenerAdapter() {
        }

        public BeforePhaseListenerAdapter(MethodExpression methodExpression) {
            super(methodExpression);
        }

        public void beforePhase(PhaseEvent event) {
            if (PhaseId.RESTORE_VIEW.getOrdinal() != event.getPhaseId().getOrdinal()) {
                this._methodExpression.invoke(FacesContext.getCurrentInstance().getELContext(), new Object[]{event});
            }
        }
    }
}

