/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsf.taglib;

import com.caucho.util.L10N;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.webapp.UIComponentTagBase;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class PhaseListenerTag
extends TagSupport {
    private static final L10N L = new L10N(PhaseListenerTag.class);
    private ValueExpression _typeExpr;
    private ValueExpression _bindingExpr;

    public void setType(ValueExpression type) {
        this._typeExpr = type;
    }

    public void setBinding(ValueExpression binding) {
        this._bindingExpr = binding;
    }

    public int doStartTag() throws JspException {
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponentTagBase viewTag = this.findRootView();
        if (viewTag == null) {
            throw new JspException(L.l("f:phaseListener must be nested inside a f:view tag."));
        }
        if (viewTag.getCreated()) {
            UIViewRoot viewRoot = (UIViewRoot)viewTag.getComponentInstance();
            PhaseListener listener = null;
            ELContext elContext = context.getELContext();
            if (this._bindingExpr != null) {
                listener = (PhaseListener)this._bindingExpr.getValue(elContext);
            }
            if (listener == null && this._typeExpr != null) {
                String type = (String)this._typeExpr.getValue(elContext);
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> cl = Class.forName(type, false, loader);
                    listener = (PhaseListener)cl.newInstance();
                }
                catch (Exception e) {
                    throw new JspException((Throwable)e);
                }
                if (this._bindingExpr != null) {
                    this._bindingExpr.setValue(elContext, (Object)listener);
                }
            }
            viewRoot.addPhaseListener(listener);
        }
        return 0;
    }

    private UIComponentTagBase findRootView() {
        UIComponentTagBase compTag = null;
        for (PhaseListenerTag tag = this; tag != null; tag = tag.getParent()) {
            if (!(tag instanceof UIComponentTagBase)) continue;
            compTag = (UIComponentTagBase)tag;
        }
        return compTag;
    }
}

