/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.util.TimedCache;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleManager {
    private static final L10N L = new L10N(BundleManager.class);
    private static final Logger log = Log.open(BundleManager.class);
    static LocalizationContext NULL_BUNDLE = new LocalizationContext();
    private static EnvironmentLocal<BundleManager> _envBundle = new EnvironmentLocal();
    private TimedCache<String, LocalizationContext> _bundleCache;

    private BundleManager() {
        long updateInterval = Environment.getDependencyCheckInterval();
        this._bundleCache = new TimedCache(256, updateInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleManager create() {
        BundleManager manager;
        EnvironmentLocal<BundleManager> environmentLocal = _envBundle;
        synchronized (environmentLocal) {
            manager = _envBundle.get();
            if (manager == null) {
                manager = new BundleManager();
                _envBundle.set(manager);
            }
        }
        return manager;
    }

    public LocalizationContext getBundle(String name, String cacheKey, Enumeration<Locale> locales) {
        LocalizationContext cachedValue = (LocalizationContext)this._bundleCache.get((Object)cacheKey);
        if (cachedValue != null) {
            return cachedValue == NULL_BUNDLE ? null : cachedValue;
        }
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            LocalizationContext bundle = this.getBundle(name, locale);
            if (bundle == null) continue;
            this._bundleCache.put((Object)cacheKey, (Object)bundle);
            return bundle;
        }
        this._bundleCache.put((Object)cacheKey, (Object)NULL_BUNDLE);
        return null;
    }

    public LocalizationContext getBundle(String name, Locale locale) {
        String cacheName = name + '_' + locale.getLanguage() + '_' + locale.getCountry() + '_' + locale.getVariant();
        LocalizationContext bundle = (LocalizationContext)this._bundleCache.get((Object)cacheName);
        if (bundle != null) {
            return bundle != NULL_BUNDLE ? bundle : null;
        }
        String fullName = cacheName;
        ResourceBundle resourceBundle = this.getBaseBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._bundleCache.put((Object)cacheName, (Object)bundle);
            return bundle;
        }
        fullName = name + '_' + locale.getLanguage() + '_' + locale.getCountry();
        resourceBundle = this.getBaseBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._bundleCache.put((Object)cacheName, (Object)bundle);
            return bundle;
        }
        fullName = name + '_' + locale.getLanguage();
        resourceBundle = this.getBaseBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._bundleCache.put((Object)cacheName, (Object)bundle);
            return bundle;
        }
        this._bundleCache.put((Object)cacheName, (Object)NULL_BUNDLE);
        return null;
    }

    public LocalizationContext getBundle(String name) {
        if (name == null) {
            return null;
        }
        LocalizationContext bundle = (LocalizationContext)this._bundleCache.get((Object)name);
        if (bundle != null) {
            return bundle != NULL_BUNDLE ? bundle : null;
        }
        ResourceBundle resourceBundle = this.getBaseBundle(name);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle);
            this._bundleCache.put((Object)name, (Object)bundle);
            return bundle;
        }
        this._bundleCache.put((Object)name, (Object)NULL_BUNDLE);
        return null;
    }

    private ResourceBundle getBaseBundle(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            ResourceBundle rb;
            Class<?> cl = Class.forName(name, false, loader);
            if (cl != null && (rb = (ResourceBundle)cl.newInstance()) != null) {
                return rb;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            InputStream is = loader.getResourceAsStream(name.replace('.', '/') + ".properties");
            if (is instanceof ReadStream) {
                Path path = ((ReadStream)is).getPath();
                Environment.addDependency((Dependency)path.createDepend());
            }
            PropertyResourceBundle bundle = new PropertyResourceBundle(is);
            is.close();
            return bundle;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

