/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.AbstractBodyContent;
import com.caucho.jsp.AbstractJspWriter;
import com.caucho.jsp.PageContextImpl;
import com.caucho.server.connection.AbstractResponseStream;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspWriter;

public class JspWriterAdapter
extends AbstractBodyContent {
    private static final Logger log = Logger.getLogger(JspWriterAdapter.class.getName());
    private static final L10N L = new L10N(JspWriterAdapter.class);
    private JspWriter _parent;
    private AbstractResponseStream _out;
    private PageContextImpl _pageContext;
    private boolean _isClosed;

    JspWriterAdapter() {
    }

    void init(PageContextImpl pageContext) {
        this._pageContext = pageContext;
        this._out = null;
        this._isClosed = false;
    }

    void init(JspWriter parent, AbstractResponseStream out) {
        this._parent = parent;
        this._out = out;
        this._isClosed = false;
    }

    public final void write(char[] buf, int offset, int length) throws IOException {
        if (this._isClosed) {
            if (log.isLoggable(Level.FINE)) {
                log.fine((Object)((Object)this) + " write() forbidden after writer is closed");
            }
            return;
        }
        this._out.print(buf, offset, length);
    }

    public final void write(int ch) throws IOException {
        if (this._isClosed) {
            if (Character.isWhitespace(ch)) {
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine((Object)((Object)this) + " write() forbidden after writer is closed");
            }
            return;
        }
        this._out.print(ch);
    }

    public final void println() throws IOException {
        if (this._isClosed) {
            if (log.isLoggable(Level.FINE)) {
                log.fine((Object)((Object)this) + " write() forbidden after writer is closed");
            }
            return;
        }
        this._out.print(10);
    }

    public final void write(String s, int off, int len) throws IOException {
        if (this._isClosed) {
            if (log.isLoggable(Level.FINE)) {
                log.fine((Object)((Object)this) + " write() forbidden after writer is closed");
            }
            return;
        }
        char[] writeBuffer = this._out.getCharBuffer();
        int size = writeBuffer.length;
        int writeLength = this._out.getCharOffset();
        int end = off + len;
        while (off < end) {
            int sublen = end - off;
            if (size - writeLength < sublen) {
                if (size == writeLength) {
                    writeBuffer = this._out.nextCharBuffer(writeLength);
                    writeLength = 0;
                    if (size < sublen) {
                        sublen = size;
                    }
                } else {
                    sublen = size - writeLength;
                }
            }
            int tail = off + sublen;
            s.getChars(off, tail, writeBuffer, writeLength);
            off = tail;
            writeLength += sublen;
        }
        this._out.setCharOffset(writeLength);
    }

    public int getBufferSize() {
        return this._out.getBufferSize();
    }

    public int getRemaining() {
        return this._out.getRemaining();
    }

    public void clear() throws IOException {
        if (this._isClosed) {
            if (log.isLoggable(Level.FINE)) {
                log.fine((Object)((Object)this) + " write() forbidden after writer is closed");
            }
            return;
        }
        this._out.clear();
    }

    public void clearBuffer() throws IOException {
        if (this._isClosed) {
            return;
        }
        this._out.clearBuffer();
    }

    public void flushBuffer() throws IOException {
        if (this._isClosed) {
            if (log.isLoggable(Level.FINE)) {
                log.fine((Object)((Object)this) + " write() forbidden after writer is closed");
            }
            return;
        }
        this._out.flushBuffer();
    }

    public void flush() throws IOException {
        if (this._isClosed) {
            if (log.isLoggable(Level.FINE)) {
                log.fine((Object)((Object)this) + " write() forbidden after writer is closed");
            }
            return;
        }
        this._out.flushChar();
    }

    AbstractJspWriter popWriter() {
        try {
            this.close();
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        return super.popWriter();
    }

    public final void close() throws IOException {
        this._isClosed = true;
        this._out = null;
        this._parent = null;
        this._pageContext = null;
    }
}

