/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.CauchoPage;
import com.caucho.jsp.JspManager;
import com.caucho.jsp.PageManager;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.connection.ToCharResponseAdapter;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.QDate;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Page
implements Servlet,
ServletConfig,
CauchoPage {
    protected static final Logger _caucho_log = Log.open(Page.class);
    private ServletConfig _config;
    private WebApp _webApp;
    private ArrayList<PersistentDependency> _depends;
    private ArrayList<Depend> _cacheDepends;
    private String _media;
    protected String _contentType;
    protected boolean _alwaysModified;
    protected boolean _neverModified;
    private PageManager.Entry _entry;
    private long _lastModified;
    private String _lastModifiedString;
    private String _etag;
    private QDate _calendar;
    private long _updateInterval = Environment.getDependencyCheckInterval();
    private long _lastUpdateCheck;
    private JspManager _jspManager;
    private boolean _isRecompiling = false;
    private int _useCount;
    private boolean _isDead = true;

    @Override
    public void init(Path path) throws ServletException {
    }

    void _caucho_setContentType(String contentType) {
        this._contentType = contentType;
    }

    void _caucho_setUpdateInterval(long updateInterval) {
        this._updateInterval = updateInterval;
    }

    void _caucho_setJspManager(JspManager manager) {
        this._jspManager = manager;
    }

    void _caucho_unload() {
        if (this._jspManager != null) {
            this._jspManager.unload(this);
        }
    }

    void _caucho_setEntry(PageManager.Entry entry) {
        this._entry = entry;
    }

    protected void _caucho_setContentType(String contentType, String encoding) {
        if (encoding != null && encoding.equals("ISO-8859-1")) {
            encoding = null;
        }
        this._contentType = contentType;
    }

    void _caucho_setUncacheable() {
        this._cacheDepends = null;
    }

    protected void _caucho_setAlwaysModified() {
        if (this._cacheDepends == null) {
            this._alwaysModified = true;
        }
    }

    protected void _caucho_setModified() {
        this._alwaysModified = true;
    }

    protected void _caucho_setNeverModified(boolean modified) {
        this._neverModified = modified;
    }

    protected void _caucho_addDepend(Path path) {
        PersistentDependency depend = path.createDepend();
        if (depend instanceof Depend) {
            ((Depend)depend).setRequireSource(this.getRequireSource());
        }
        this._caucho_addDepend(depend);
    }

    protected void _caucho_addDepend(PersistentDependency depend) {
        if (this._depends == null) {
            this._depends = new ArrayList();
        }
        if (!this._depends.contains(depend)) {
            this._depends.add(depend);
        }
    }

    protected void _caucho_addDepend(ArrayList<PersistentDependency> dependList) {
        if (dependList == null) {
            return;
        }
        for (int i = 0; i < dependList.size(); ++i) {
            this._caucho_addDepend(dependList.get(i));
        }
    }

    protected void _caucho_addDepend(Path path, long lastModified, long length) {
        if (this._depends == null) {
            this._depends = new ArrayList();
        }
        Depend depend = new Depend(path, lastModified, length);
        depend.setRequireSource(this.getRequireSource());
        this._caucho_addDepend((PersistentDependency)depend);
    }

    protected void _caucho_setCacheable() {
        this._cacheDepends = new ArrayList();
        this._alwaysModified = false;
    }

    protected void _caucho_addCacheDepend(Path path, long lastModified, long length) {
        Depend depend;
        if (this._cacheDepends == null) {
            this._cacheDepends = new ArrayList();
        }
        if (!this._cacheDepends.contains(depend = new Depend(path, lastModified, length))) {
            this._cacheDepends.add(depend);
        }
    }

    void _caucho_setCacheable(ArrayList<Path> depends) {
        this._cacheDepends = new ArrayList();
        for (int i = 0; i < depends.size(); ++i) {
            Path path = depends.get(i);
            Depend depend = new Depend(path);
            depend.setRequireSource(this.getRequireSource());
            if (this._cacheDepends.contains(depend)) continue;
            this._cacheDepends.add(depend);
        }
    }

    @Override
    public boolean _caucho_isModified() {
        if (this._alwaysModified || this._isDead) {
            return true;
        }
        if (this._depends == null) {
            return false;
        }
        for (int i = 0; i < this._depends.size(); ++i) {
            Dependency depend = (Dependency)this._depends.get(i);
            if (!depend.isModified()) continue;
            return true;
        }
        return false;
    }

    public boolean cauchoIsModified() {
        long now = Alarm.getCurrentTime();
        if (this._alwaysModified || this._isDead) {
            return true;
        }
        if (now < this._lastUpdateCheck + this._updateInterval) {
            return false;
        }
        if (this._neverModified) {
            this._lastUpdateCheck = now;
            if (this._depends == null) {
                return false;
            }
            for (int i = 0; i < this._depends.size(); ++i) {
                Dependency depend = (Dependency)this._depends.get(i);
                if (!depend.isModified()) continue;
                return true;
            }
            return false;
        }
        boolean isModified = this._caucho_isModified();
        if (!isModified) {
            this._lastUpdateCheck = now;
        }
        return isModified;
    }

    protected HashMap<String, Method> _caucho_getFunctionMap() {
        return null;
    }

    private boolean getRequireSource() {
        return false;
    }

    public void init(ServletConfig config) throws ServletException {
        if (this._config != null) {
            return;
        }
        this._config = config;
        this._isDead = false;
        this._webApp = (WebApp)config.getServletContext();
        this.cauchoIsModified();
        if (!this.disableLog() && _caucho_log.isLoggable(Level.FINE)) {
            _caucho_log.fine(this.getClass().getName() + " init");
        }
    }

    public boolean isInit() {
        return this._config != null;
    }

    @Override
    public WebApp _caucho_getApplication() {
        return this._webApp;
    }

    public ServletContext getServletContext() {
        return this._webApp;
    }

    public String getServletName() {
        return this._config.getServletName();
    }

    public String getInitParameter(String name) {
        return this._config.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this._config.getInitParameterNames();
    }

    public void log(String msg) {
        this._webApp.log(this.getClass().getName() + ": " + msg);
    }

    public void log(String msg, Throwable cause) {
        this._webApp.log(this.getClass().getName() + ": " + msg, cause);
    }

    public String getServletInfo() {
        return "A JSP Page";
    }

    boolean disableLog() {
        JspPropertyGroup jsp = this._webApp.getJsp();
        if (jsp != null) {
            return jsp.isDisableLog();
        }
        return true;
    }

    public ServletConfig getServletConfig() {
        return this._config;
    }

    public void _caucho_init(HttpServletRequest req, HttpServletResponse res) {
        if (this._contentType != null) {
            res.setContentType(this._contentType);
        } else {
            res.setContentType("text/html");
        }
    }

    public long getLastModified(HttpServletRequest request) {
        return this._caucho_lastModified();
    }

    @Override
    public long _caucho_lastModified() {
        if (this._cacheDepends == null) {
            return 0L;
        }
        return Page.calculateLastModified(this._depends, this._cacheDepends);
    }

    public static long calculateLastModified(ArrayList<PersistentDependency> depends, ArrayList<Depend> cacheDepends) {
        int i;
        long lastModified = 0L;
        for (i = 0; i < depends.size(); ++i) {
            Depend depend;
            long modified;
            PersistentDependency dependency = depends.get(i);
            if (!(dependency instanceof Depend) || lastModified >= (modified = (depend = (Depend)dependency).getLastModified())) continue;
            lastModified = modified;
        }
        for (i = 0; cacheDepends != null && i < cacheDepends.size(); ++i) {
            Depend depend = cacheDepends.get(i);
            long modified = depend.getLastModified();
            if (lastModified >= modified) continue;
            lastModified = modified;
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageservice(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        long lastModified;
        PageManager.Entry entry = this._entry;
        if (entry != null) {
            entry.accessPage();
        }
        if ((lastModified = this.getLastModified(req)) > 0L) {
            String ifMatch;
            if (this._calendar == null) {
                this._calendar = new QDate();
            }
            String etag = this._etag;
            if (lastModified != this._lastModified) {
                CharBuffer cb = new CharBuffer();
                cb.append('\"');
                Base64.encode((CharBuffer)cb, (long)lastModified);
                cb.append('\"');
                this._etag = etag = cb.close();
                QDate qDate = this._calendar;
                synchronized (qDate) {
                    this._calendar.setGMTTime(lastModified);
                    this._lastModifiedString = this._calendar.printDate();
                }
                this._lastModified = lastModified;
            }
            if (etag.equals(ifMatch = req.getHeader("If-None-Match"))) {
                res.sendError(304);
                return;
            }
            String ifModifiedSince = req.getHeader("If-Modified-Since");
            if (this._lastModifiedString.equals(ifModifiedSince)) {
                res.sendError(304);
                return;
            }
            res.setHeader("ETag", etag);
            res.setHeader("Last-Modified", this._lastModifiedString);
        }
        if (res instanceof CauchoResponse) {
            this.service((ServletRequest)req, (ServletResponse)res);
        } else {
            ToCharResponseAdapter resAdapt = ToCharResponseAdapter.create(res);
            try {
                this.service((ServletRequest)req, resAdapt);
                Object var11_9 = null;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                resAdapt.close();
                ToCharResponseAdapter.free(resAdapt);
                throw throwable;
            }
            resAdapt.close();
            ToCharResponseAdapter.free(resAdapt);
            {
            }
        }
    }

    protected void setDead() {
        this._isDead = true;
    }

    public boolean isDead() {
        return this._isDead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startRecompiling() {
        boolean allowRecompiling;
        Page page = this;
        synchronized (page) {
            allowRecompiling = this._isDead || !this._isRecompiling;
            this._isRecompiling = true;
        }
        return allowRecompiling;
    }

    String getErrorPage() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _caucho_use() {
        Page page = this;
        synchronized (page) {
            ++this._useCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _caucho_free() {
        Page page = this;
        synchronized (page) {
            --this._useCount;
        }
        if (this._useCount <= 0) {
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this._isDead) {
            return;
        }
        this._isDead = true;
        this._entry = null;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClass().getClassLoader());
            _caucho_log.fine(this.getClass().getName() + " destroy");
            Object var4_3 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }
}

