/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.config.ConfigContext;
import com.caucho.config.j2ee.InjectIntrospector;
import com.caucho.config.program.ConfigProgram;
import com.caucho.java.JavaCompiler;
import com.caucho.jsp.Page;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.util.LruCache;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PageManager {
    private static final Logger log = Log.open(PageManager.class);
    static final long ACCESS_INTERVAL = 60000L;
    protected WebApp _webApp;
    private Path _classDir;
    private long _updateInterval = 1000L;
    private boolean _isAdapter;
    private boolean _omitInitLog;
    private int _pageCacheMax = 1024;
    private LruCache<String, Entry> _cache;
    protected boolean _autoCompile = true;

    PageManager() {
    }

    void initWebApp(WebApp webApp) {
        this._webApp = webApp;
        this._classDir = CauchoSystem.getWorkPath();
        long interval = Environment.getDependencyCheckInterval();
        JspPropertyGroup jspPropertyGroup = this._webApp.getJsp();
        if (jspPropertyGroup != null) {
            this._autoCompile = jspPropertyGroup.isAutoCompile();
            if (jspPropertyGroup.getJspMax() > 0) {
                this._pageCacheMax = jspPropertyGroup.getJspMax();
            }
            if (jspPropertyGroup.getDependencyCheckInterval() != Long.MIN_VALUE) {
                interval = jspPropertyGroup.getDependencyCheckInterval();
            }
        }
        if (interval < 0L) {
            interval = 0x3FFFFFFFL;
        }
        this._updateInterval = interval;
    }

    void setPageCacheMax(int max) {
        this._pageCacheMax = max;
    }

    public Path getClassDir() {
        if (this._classDir != null) {
            return this._classDir;
        }
        Path appDir = this._webApp.getAppDir();
        if (appDir instanceof MemoryPath) {
            String workPathName = "./" + this._webApp.getURL();
            Path path = CauchoSystem.getWorkPath().lookup(workPathName);
            return path;
        }
        return appDir.lookup("WEB-INF/work");
    }

    public Path getAppDir() {
        return this._webApp.getAppDir();
    }

    WebApp getWebApp() {
        return this._webApp;
    }

    public Page getPage(String uri, Path path) throws Exception {
        return this.getPage(uri, uri, path, null);
    }

    public Page getPage(String uri, String pageURI, Path path, ServletConfig config) throws Exception {
        return this.getPage(uri, pageURI, path, config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(String uri, String pageURI, Path path, ServletConfig config, ArrayList<PersistentDependency> dependList) throws Exception {
        LruCache<String, Entry> cache = this._cache;
        if (cache == null) {
            this.initPageManager();
            PageManager pageManager = this;
            synchronized (pageManager) {
                if (this._cache == null) {
                    this._cache = new LruCache(this._pageCacheMax);
                }
                cache = this._cache;
            }
        }
        Entry entry = null;
        Object object = cache;
        synchronized (object) {
            entry = (Entry)cache.get((Object)uri);
            if (entry == null) {
                entry = new Entry(uri);
                cache.put((Object)uri, (Object)entry);
            }
        }
        object = entry;
        synchronized (object) {
            String className;
            Page page = entry.getPage();
            if (page != null && !page.cauchoIsModified()) {
                return page;
            }
            if (page != null && !page.isDead()) {
                try {
                    page.destroy();
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Jsp[] uri:" + uri + "(cp:" + this.getWebApp().getContextPath() + ",app:" + this.getWebApp().getAppDir() + ") -> " + path);
            }
            Path appDir = this.getWebApp().getAppDir();
            String rawClassName = pageURI;
            if (path.getPath().startsWith(appDir.getPath())) {
                rawClassName = path.getPath().substring(appDir.getPath().length());
            }
            if ((page = this.createPage(path, pageURI, className = JavaCompiler.mangleName("jsp/" + rawClassName), config, dependList)) == null) {
                log.fine("Jsp[] cannot create page " + path.getURL());
                throw new FileNotFoundException(this.getWebApp().getContextPath() + pageURI);
            }
            if (!this._autoCompile) {
                page._caucho_setNeverModified(true);
            }
            page._caucho_setUpdateInterval(this._updateInterval);
            try {
                ArrayList<ConfigProgram> injectList = new ArrayList<ConfigProgram>();
                InjectIntrospector.introspectInject(injectList, page.getClass());
                ConfigContext env = new ConfigContext();
                for (ConfigProgram inject : injectList) {
                    inject.inject(page, env);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            entry.setPage(page);
            return page;
        }
    }

    protected void initPageManager() {
    }

    abstract Page createPage(Path var1, String var2, String var3, ServletConfig var4, ArrayList<PersistentDependency> var5) throws Exception;

    void killPage(HttpServletRequest request, HttpServletResponse response, Page page) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        LruCache<String, Entry> cache = this._cache;
        this._cache = null;
        if (cache == null) {
            return;
        }
        LruCache<String, Entry> lruCache = cache;
        synchronized (lruCache) {
            Iterator iter = cache.values();
            while (iter.hasNext()) {
                Entry entry = (Entry)iter.next();
                Page page = entry != null ? entry.getPage() : null;
                try {
                    if (page == null || page.isDead()) continue;
                    page.destroy();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    class Entry
    implements CacheListener {
        private String _key;
        Page _page;
        private long _lastAccessTime;

        Entry(String key) {
            this._key = key;
        }

        void setPage(Page page) {
            this._page = page;
            if (page != null) {
                page._caucho_setEntry(this);
            }
        }

        Page getPage() {
            return this._page;
        }

        public void accessPage() {
            long now = Alarm.getCurrentTime();
            if (now < this._lastAccessTime + 60000L) {
                return;
            }
            this._lastAccessTime = now;
            if (PageManager.this._cache != null) {
                PageManager.this._cache.get((Object)this._key);
            }
        }

        public void removeEvent() {
            Page page = this._page;
            this._page = null;
            if (page != null && !page.isDead()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("dropping page " + page);
                }
                page.setDead();
                page.destroy();
            }
        }
    }
}

