/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.el;

import com.caucho.jsp.PageContextImpl;
import com.caucho.jsp.TaglibManager;
import com.caucho.jsp.el.JspExpressionFactoryImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.PageContext;

public class JspApplicationContextImpl
implements JspApplicationContext {
    private static final L10N L = new L10N(JspApplicationContextImpl.class);
    private final WebApp _webApp;
    private final ExpressionFactory _expressionFactory;
    private TaglibManager _taglibManager;
    private ELResolver[] _resolverArray = new ELResolver[0];
    private ELContextListener[] _listenerArray = new ELContextListener[0];
    private boolean _hasRequest;
    private FreeList<PageContextImpl> _freePages = new FreeList(256);

    public JspApplicationContextImpl(WebApp webApp) {
        this._webApp = webApp;
        this._expressionFactory = new JspExpressionFactoryImpl(this);
    }

    WebApp getWebApp() {
        return this._webApp;
    }

    public TaglibManager getTaglibManager() {
        return this._taglibManager;
    }

    public void setTaglibManager(TaglibManager taglibManager) {
        this._taglibManager = taglibManager;
    }

    public void addELContextListener(ELContextListener listener) {
        if (this._hasRequest) {
            throw new IllegalStateException(L.l("Cannot add ELContextListener after requests have started."));
        }
        ELContextListener[] listenerArray = new ELContextListener[this._listenerArray.length + 1];
        System.arraycopy(this._listenerArray, 0, listenerArray, 0, this._listenerArray.length);
        listenerArray[this._listenerArray.length] = listener;
        this._listenerArray = listenerArray;
    }

    public ELContextListener[] getELListenerArray() {
        this._hasRequest = true;
        return this._listenerArray;
    }

    public void addELResolver(ELResolver resolver) {
        if (this._hasRequest) {
            throw new IllegalStateException(L.l("Can't add ELResolver after starting request."));
        }
        ELResolver[] resolverArray = new ELResolver[this._resolverArray.length + 1];
        System.arraycopy(this._resolverArray, 0, resolverArray, 0, this._resolverArray.length);
        resolverArray[this._resolverArray.length] = resolver;
        this._resolverArray = resolverArray;
    }

    public ELResolver[] getELResolverArray() {
        return this._resolverArray;
    }

    public ExpressionFactory getExpressionFactory() {
        return this._expressionFactory;
    }

    public PageContextImpl allocatePageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int buffer, boolean autoFlush) {
        PageContextImpl pc = (PageContextImpl)this._freePages.allocate();
        if (pc == null) {
            pc = new PageContextImpl();
        }
        try {
            pc.initialize(servlet, request, response, errorPageURL, needsSession, buffer, autoFlush);
        }
        catch (Exception e) {
            // empty catch block
        }
        return pc;
    }

    public PageContextImpl allocatePageContext(Servlet servlet, WebApp app, ServletRequest request, ServletResponse response, String errorPageURL, HttpSession session, int buffer, boolean autoFlush, boolean isPrintNullAsBlank) {
        PageContextImpl pc = (PageContextImpl)this._freePages.allocate();
        if (pc == null) {
            pc = new PageContextImpl();
        }
        pc.initialize(servlet, app, request, response, errorPageURL, session, buffer, autoFlush, isPrintNullAsBlank);
        return pc;
    }

    public PageContext getPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int buffer, boolean autoFlush) {
        return this.allocatePageContext(servlet, request, response, errorPageURL, needsSession, buffer, autoFlush);
    }

    public void releasePageContext(PageContext pc) {
        if (pc != null) {
            pc.release();
            if (pc instanceof PageContextImpl) {
                this._freePages.free((Object)((PageContextImpl)pc));
            }
        }
    }

    public void freePageContext(PageContextImpl pc) {
        if (pc != null) {
            pc.release();
            if (pc instanceof PageContextImpl) {
                this._freePages.free((Object)pc);
            }
        }
    }

    public String toString() {
        return "JspApplicationContextImpl[" + this._webApp + "]";
    }
}

