/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.el;

import com.caucho.el.BigDecimalValueExpression;
import com.caucho.el.BigIntegerValueExpression;
import com.caucho.el.BooleanValueExpression;
import com.caucho.el.ByteValueExpression;
import com.caucho.el.CharacterValueExpression;
import com.caucho.el.DoubleValueExpression;
import com.caucho.el.Expr;
import com.caucho.el.FloatValueExpression;
import com.caucho.el.IntegerValueExpression;
import com.caucho.el.LongValueExpression;
import com.caucho.el.MethodExpressionImpl;
import com.caucho.el.ObjectValueExpression;
import com.caucho.el.ShortValueExpression;
import com.caucho.el.StringValueExpression;
import com.caucho.jsp.el.JspApplicationContextImpl;
import com.caucho.jsp.el.JspELParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspExpressionFactoryImpl
extends ExpressionFactory {
    private static final HashMap<Class, CoerceType> _coerceMap = new HashMap();
    private final JspApplicationContextImpl _jspApplicationContext;

    JspExpressionFactoryImpl(JspApplicationContextImpl jspApplicationContext) {
        this._jspApplicationContext = jspApplicationContext;
    }

    public Object coerceToType(Object obj, Class<?> targetType) throws ELException {
        CoerceType type = _coerceMap.get(targetType);
        if (type == null) {
            return obj;
        }
        switch (type) {
            case BOOLEAN: {
                return Expr.toBoolean(obj, null) ? Boolean.TRUE : Boolean.FALSE;
            }
            case CHARACTER: {
                return Character.valueOf(Expr.toCharacter(obj, null));
            }
            case BYTE: {
                return new Byte((byte)Expr.toLong(obj, null));
            }
            case SHORT: {
                return new Short((short)Expr.toLong(obj, null));
            }
            case INTEGER: {
                return new Integer((int)Expr.toLong(obj, null));
            }
            case LONG: {
                return new Long(Expr.toLong(obj, null));
            }
            case FLOAT: {
                return new Float((float)Expr.toDouble(obj, null));
            }
            case DOUBLE: {
                return new Double(Expr.toDouble(obj, null));
            }
            case STRING: {
                if (obj == null) {
                    return "";
                }
                return obj.toString();
            }
            case BIG_DECIMAL: {
                return Expr.toBigDecimal(obj, null);
            }
            case BIG_INTEGER: {
                return Expr.toBigInteger(obj, null);
            }
        }
        return null;
    }

    public MethodExpression createMethodExpression(ELContext context, String expression, Class<?> expectedReturnType, Class<?>[] expectedParamTypes) throws ELException {
        JspELParser parser = new JspELParser(context, expression);
        Expr expr = parser.parse();
        return new MethodExpressionImpl(expr, expression, expectedReturnType, expectedParamTypes);
    }

    public ValueExpression createValueExpression(ELContext context, String expression, Class<?> expectedType) throws ELException {
        JspELParser parser = new JspELParser(context, expression);
        Expr expr = parser.parse();
        return JspExpressionFactoryImpl.createValueExpression(expr, expression, expectedType);
    }

    public static ValueExpression createValueExpression(Expr expr, String expression, Class<?> expectedType) {
        CoerceType type = _coerceMap.get(expectedType);
        if (type == null) {
            return new ObjectValueExpression(expr, expression);
        }
        switch (type) {
            case BOOLEAN: {
                return new BooleanValueExpression(expr, expression);
            }
            case CHARACTER: {
                return new CharacterValueExpression(expr, expression);
            }
            case BYTE: {
                return new ByteValueExpression(expr, expression);
            }
            case SHORT: {
                return new ShortValueExpression(expr, expression);
            }
            case INTEGER: {
                return new IntegerValueExpression(expr, expression);
            }
            case LONG: {
                return new LongValueExpression(expr, expression);
            }
            case FLOAT: {
                return new FloatValueExpression(expr, expression);
            }
            case DOUBLE: {
                return new DoubleValueExpression(expr, expression);
            }
            case STRING: {
                return new StringValueExpression(expr, expression);
            }
            case BIG_DECIMAL: {
                return new BigDecimalValueExpression(expr, expression);
            }
            case BIG_INTEGER: {
                return new BigIntegerValueExpression(expr, expression);
            }
        }
        return new ObjectValueExpression(expr, expression);
    }

    public ValueExpression createValueExpression(Object instance, Class<?> expectedType) throws ELException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "JspExpressionFactoryImpl[" + this._jspApplicationContext.getWebApp() + "]";
    }

    static {
        _coerceMap.put(Boolean.TYPE, CoerceType.BOOLEAN);
        _coerceMap.put(Boolean.class, CoerceType.BOOLEAN);
        _coerceMap.put(Byte.TYPE, CoerceType.BYTE);
        _coerceMap.put(Byte.class, CoerceType.BYTE);
        _coerceMap.put(Short.TYPE, CoerceType.SHORT);
        _coerceMap.put(Short.class, CoerceType.SHORT);
        _coerceMap.put(Integer.TYPE, CoerceType.INTEGER);
        _coerceMap.put(Integer.class, CoerceType.INTEGER);
        _coerceMap.put(Long.TYPE, CoerceType.LONG);
        _coerceMap.put(Long.class, CoerceType.LONG);
        _coerceMap.put(Float.TYPE, CoerceType.FLOAT);
        _coerceMap.put(Float.class, CoerceType.FLOAT);
        _coerceMap.put(Double.TYPE, CoerceType.DOUBLE);
        _coerceMap.put(Double.class, CoerceType.DOUBLE);
        _coerceMap.put(Character.TYPE, CoerceType.CHARACTER);
        _coerceMap.put(Character.class, CoerceType.CHARACTER);
        _coerceMap.put(String.class, CoerceType.STRING);
        _coerceMap.put(BigDecimal.class, CoerceType.BIG_DECIMAL);
        _coerceMap.put(BigInteger.class, CoerceType.BIG_INTEGER);
        _coerceMap.put(Void.TYPE, CoerceType.VOID);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CoerceType {
        BOOLEAN,
        CHARACTER,
        STRING,
        INTEGER,
        DOUBLE,
        LONG,
        FLOAT,
        SHORT,
        BYTE,
        BIG_INTEGER,
        BIG_DECIMAL,
        VOID;

    }
}

