/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.PageContextImpl;
import com.caucho.util.CharBuffer;
import com.caucho.util.EnumIterator;
import com.caucho.util.L10N;
import com.caucho.util.NullIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.LoopTag;
import javax.servlet.jsp.jstl.core.LoopTagStatus;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.TagSupport;

public class ForEachTag
extends TagSupport
implements IterationTag,
LoopTag,
LoopTagStatus {
    private static L10N L = new L10N(ForEachTag.class);
    protected Expr _itemsExpr;
    protected Expr _beginExpr;
    protected Expr _endExpr;
    protected Expr _stepExpr;
    protected String _var;
    protected String _varStatus;
    protected Iterator _iterator;
    protected int _begin;
    protected int _end;
    protected int _step;
    protected Object _initialVar;
    protected Object _current;
    protected int _index;
    protected int _count;

    public void setItems(Expr items) {
        this._itemsExpr = items;
    }

    public void setBegin(Expr begin) {
        this._beginExpr = begin;
    }

    public void setEnd(Expr end) {
        this._endExpr = end;
    }

    public void setStep(Expr step) {
        this._stepExpr = step;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setVarStatus(String var) {
        this._varStatus = var;
    }

    public int doStartTag() throws JspException {
        try {
            this._iterator = null;
            this._index = 0;
            this._count = 0;
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            ELContext env = pageContext.getELContext();
            this._begin = this._beginExpr != null ? (int)this._beginExpr.evalLong(env) : -1;
            this._end = this._endExpr != null ? (int)this._endExpr.evalLong(env) : Integer.MAX_VALUE;
            this._step = this._stepExpr != null ? (int)this._stepExpr.evalLong(env) : 0;
            Object items = null;
            if (this._itemsExpr != null) {
                items = this._itemsExpr.evalObject(env);
                this._iterator = ForEachTag.getIterator(items);
                while (this._index < this._begin && this._iterator.hasNext()) {
                    ++this._index;
                    this._iterator.next();
                }
            } else {
                if (this._beginExpr == null) {
                    throw new JspException(L.l("c:forEach must specify `items' or `begin'"));
                }
                if (this._endExpr == null) {
                    throw new JspException(L.l("c:forEach must specify `items' or `begin'"));
                }
                this._iterator = new RangeIterator(this._begin, this._end);
                this._end = -1;
            }
            if (this._varStatus != null) {
                pageContext.setAttribute(this._varStatus, (Object)this);
            }
            if (this._var != null) {
                this._initialVar = pageContext.getAttribute(this._var);
            }
            return this.doAfterBody();
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    public int doAfterBody() throws JspException {
        if (this._iterator == null) {
            if (this._var != null) {
                this.pageContext.setAttribute(this._var, this._initialVar);
            }
            return 0;
        }
        if (this._iterator.hasNext()) {
            for (int stepCount = this._step <= 0 || this._count == 0 ? 1 : this._step; stepCount > 0; --stepCount) {
                if (!this._iterator.hasNext()) {
                    if (this._var != null) {
                        this.pageContext.setAttribute(this._var, this._initialVar);
                    }
                    return 0;
                }
                ++this._index;
                this._current = this._iterator.next();
            }
            ++this._count;
            if (this._var != null) {
                this.pageContext.setAttribute(this._var, this._current);
            }
            if (this._index - 1 <= this._end || this._end < 0) {
                return 2;
            }
            if (this._var != null) {
                this.pageContext.setAttribute(this._var, this._initialVar);
            }
            return 0;
        }
        if (this._var != null) {
            this.pageContext.setAttribute(this._var, this._initialVar);
        }
        return 0;
    }

    public LoopTagStatus getLoopStatus() {
        return this;
    }

    public Object getCurrent() {
        return this._current;
    }

    public int getIndex() {
        return this._index - 1;
    }

    public int getCount() {
        return this._count;
    }

    public boolean isFirst() {
        return this._count == 1;
    }

    public boolean isLast() {
        if (this._iterator == null || !this._iterator.hasNext()) {
            return true;
        }
        return this._step > 0 && this._step + this._index > this._end;
    }

    public Integer getBegin() {
        if (this._beginExpr != null && this._itemsExpr != null) {
            return new Integer(this._begin);
        }
        return null;
    }

    public Integer getEnd() {
        if (this._endExpr != null && this._itemsExpr != null) {
            return new Integer(this._end);
        }
        return null;
    }

    public Integer getStep() {
        if (this._stepExpr != null) {
            return new Integer(this._step);
        }
        return null;
    }

    public static Iterator getIterator(Object items) throws JspTagException {
        if (items == null) {
            return NullIterator.create();
        }
        if (items instanceof Map) {
            return ((Map)items).entrySet().iterator();
        }
        if (items instanceof Collection) {
            return ((Collection)items).iterator();
        }
        if (items.getClass().isArray()) {
            return new ArrayIterator(items);
        }
        if (items instanceof Iterator) {
            return (Iterator)items;
        }
        if (items instanceof Enumeration) {
            return new EnumIterator((Enumeration)items);
        }
        if (items instanceof String) {
            return new StringIterator((String)items);
        }
        throw new JspTagException(L.l("unknown items value `{0}'", items));
    }

    public static class RangeIterator
    implements Iterator {
        private int _end;
        private int _i;

        RangeIterator(int begin, int end) {
            this._i = begin;
            this._end = end;
        }

        public boolean hasNext() {
            return this._i <= this._end;
        }

        public Object next() {
            if (this._i <= this._end) {
                return new Integer(this._i++);
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class StringIterator
    implements Iterator {
        private String _value;
        private int _length;
        private int _i;
        private CharBuffer _cb = new CharBuffer();

        StringIterator(String value) {
            this._value = value;
            this._length = value.length();
        }

        public boolean hasNext() {
            return this._i < this._length;
        }

        public Object next() {
            this._cb.clear();
            char ch = '\u0000';
            while (this._i < this._length && (ch = this._value.charAt(this._i)) != ',') {
                this._cb.append(ch);
                ++this._i;
            }
            ++this._i;
            return this._cb.toString();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class ArrayIterator
    implements Iterator {
        private Object _array;
        private int _index;
        private int _length;

        ArrayIterator(Object array) {
            this._array = array;
            this._length = Array.getLength(array);
        }

        public boolean hasNext() {
            return this._index < this._length;
        }

        public Object next() {
            if (this._index < this._length) {
                return Array.get(this._array, this._index++);
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

